/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeTallGrassBlock;

public class SlimeGrassBlock
extends SnowyDirtBlock
implements BonemealableBlock {
    private final SlimeType foliageType;

    public SlimeGrassBlock(BlockBehaviour.Properties properties, SlimeType foliageType) {
        super(properties);
        this.foliageType = foliageType;
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.foliageType != SlimeType.ICHOR) {
            super.m_49811_(group, items);
        }
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        return world.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public static void growGrass(ServerLevel world, Random rand, BlockPos pos, TagKey<Block> validBase, SlimeType foliageType, boolean includeSapling, boolean spread) {
        BlockPos up = pos.m_7494_();
        block0: for (int i = 0; i < 128; ++i) {
            int plant;
            BlockState plantState;
            BlockPos target = up;
            for (int j = 0; j < i / 16; ++j) {
                target = target.m_142082_(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1);
                BlockPos below = target.m_7495_();
                BlockState belowState = world.m_8055_(below);
                if (world.m_8055_(target).m_60838_((BlockGetter)world, target)) continue block0;
                if (spread && TinkerWorld.allDirt.contains((IForgeRegistryEntry)belowState.m_60734_())) {
                    BlockState grassState = SlimeGrassBlock.getStateFromDirt(belowState, foliageType);
                    if (grassState == null) continue block0;
                    world.m_46597_(below, grassState);
                    continue block0;
                }
                if (!belowState.m_204336_(validBase)) continue block0;
            }
            if (!world.m_46859_(target) || !(plantState = (plant = rand.nextInt(32)) == 0 && includeSapling ? ((Block)TinkerWorld.slimeSapling.get((Enum)foliageType)).m_49966_() : (plant < 6 ? ((SlimeTallGrassBlock)TinkerWorld.slimeFern.get((Enum)foliageType)).m_49966_() : ((SlimeTallGrassBlock)TinkerWorld.slimeTallGrass.get((Enum)foliageType)).m_49966_())).m_60710_((LevelReader)world, target)) continue;
            world.m_7731_(target, plantState, 3);
        }
    }

    public void m_7719_(ServerLevel world, Random rand, BlockPos pos, BlockState state) {
        SlimeGrassBlock.growGrass(world, rand, pos, TinkerTags.Blocks.SLIMY_GRASS, this.foliageType, false, false);
    }

    @Deprecated
    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!world.isAreaLoaded(pos, 3)) {
            return;
        }
        if (!SlimeGrassBlock.isValidPos(state, (LevelReader)world, pos)) {
            world.m_46597_(pos, SlimeGrassBlock.getDirtState(state));
        } else if (world.m_46803_(pos.m_7494_()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos newGrass = pos.m_142082_(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                BlockState newState = SlimeGrassBlock.getStateFromDirt(world.m_8055_(newGrass), this.foliageType);
                if (newState == null || !SlimeGrassBlock.canSpread(newState, (LevelReader)world, newGrass)) continue;
                world.m_46597_(newGrass, (BlockState)newState.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(world.m_8055_(newGrass.m_7494_()).m_60713_(Blocks.f_50125_))));
            }
        }
    }

    private static boolean isValidPos(BlockState targetState, LevelReader world, BlockPos pos) {
        BlockPos above = pos.m_7494_();
        BlockState aboveState = world.m_8055_(above);
        if (aboveState.m_60713_(Blocks.f_50125_) && (Integer)aboveState.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (aboveState.m_60819_().m_76186_() == 8) {
            return false;
        }
        return LayerLightEngine.m_75667_((BlockGetter)world, (BlockState)targetState, (BlockPos)pos, (BlockState)aboveState, (BlockPos)above, (Direction)Direction.UP, (int)aboveState.m_60739_((BlockGetter)world, above)) < world.m_7469_();
    }

    private static boolean canSpread(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos above = pos.m_7494_();
        return SlimeGrassBlock.isValidPos(state, world, pos) && !world.m_6425_(above).m_205070_(FluidTags.f_13131_);
    }

    public static BlockState getDirtState(BlockState grassState) {
        Block block = grassState.m_60734_();
        for (SlimeType type : SlimeType.values()) {
            if (!TinkerWorld.slimeGrass.get((Object)type).contains((IForgeRegistryEntry)block)) continue;
            return ((Block)TinkerWorld.allDirt.get((Enum)type)).m_49966_();
        }
        return Blocks.f_50493_.m_49966_();
    }

    @Nullable
    public static BlockState getStateFromDirt(BlockState dirtState, SlimeType foliageType) {
        Block block = dirtState.m_60734_();
        for (SlimeType type : SlimeType.values()) {
            if (TinkerWorld.allDirt.get((Enum)type) != block) continue;
            return ((Block)TinkerWorld.slimeGrass.get((Object)type).get((Enum)foliageType)).m_49966_();
        }
        return null;
    }

    public SlimeType getFoliageType() {
        return this.foliageType;
    }
}

