/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalArmorLevelModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;

public class HasteModifier
extends IncrementalArmorLevelModifier {
    private static final Component MINING_SPEED = TConstruct.makeTranslation("modifier", "fake_attribute.mining_speed");
    public static final TinkerDataCapability.TinkerDataKey<Float> HASTE = TConstruct.createKey("haste");
    private static final ModifierLevelDisplay NAME = new ModifierLevelDisplay.UniqueForLevels(5);

    public HasteModifier() {
        super(HASTE);
    }

    @Override
    public Component getDisplayName(int level) {
        return NAME.nameForLevel(this, level);
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            super.onEquip(tool, level, context);
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            super.onUnequip(tool, level, context);
        }
    }

    @Override
    public void addToolStats(ToolRebuildContext context, int level, ModifierStatsBuilder builder) {
        ToolStats.MINING_SPEED.add(builder, 4.0f * this.getEffectiveLevel(context, level));
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        double boost;
        if (tool.hasTag(TinkerTags.Items.ARMOR) && (boost = 0.1 * (double)this.getScaledLevel(tool, level)) != 0.0) {
            tooltip.add((Component)this.applyStyle(new TextComponent(Util.PERCENT_BOOST_FORMAT.format(boost)).m_130946_(" ").m_7220_(MINING_SPEED)));
        }
    }
}

