/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.sling;

import java.util.Random;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.SlimeBounceHandler;
import slimeknights.tconstruct.tools.modifiers.ability.sling.SlingModifier;

public class SpringingModifier
extends SlingModifier {
    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (!tool.isBroken() && source == InteractionSource.RIGHT_CLICK) {
            ModifierUtil.startUsingItemWithDrawtime(tool, modifier.getId(), (LivingEntity)player, hand, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean onStoppedUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
        Player player;
        super.onStoppedUsing(tool, modifier, entity, timeLeft);
        if (entity instanceof Player && !(player = (Player)entity).m_21255_()) {
            player.m_36399_(0.2f);
            float f = this.getForce(tool, modifier, (LivingEntity)player, timeLeft, true) * 1.05f;
            if (f > 0.0f) {
                Vec3 look = player.m_20154_().m_82520_(0.0, 1.0, 0.0).m_82541_();
                float inaccuracy = ModifierUtil.getInaccuracy(tool, (LivingEntity)player, 1.0f) * 0.0075f;
                Random random = player.m_21187_();
                player.m_5997_((look.f_82479_ + random.nextGaussian() * (double)inaccuracy) * (double)f, (look.f_82480_ + random.nextGaussian() * (double)inaccuracy) * (double)f / 2.0, (look.f_82481_ + random.nextGaussian() * (double)inaccuracy) * (double)f);
                SlimeBounceHandler.addBounceHandler((LivingEntity)player);
                if (!entity.f_19853_.f_46443_) {
                    player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), Sounds.SLIME_SLING.getSound(), player.m_5720_(), 1.0f, 1.0f);
                    player.m_36399_(0.2f);
                    player.m_36335_().m_41524_(tool.getItem(), 3);
                    ToolDamageUtil.damageAnimated(tool, 1, entity);
                }
                return true;
            }
        }
        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Sounds.SLIME_SLING.getSound(), entity.m_5720_(), 1.0f, 0.5f);
        return true;
    }
}

