/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.ranged;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.dynamic.InventoryMenuModifier;
import slimeknights.tconstruct.library.modifiers.hook.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class BulkQuiverModifier
extends InventoryMenuModifier
implements BowAmmoModifierHook {
    private static final ResourceLocation INVENTORY_KEY = TConstruct.getResource("bulk_quiver");
    private static final ResourceLocation LAST_SLOT = TConstruct.getResource("quiver_last_selected");
    private static final Pattern ARROW = new Pattern(TConstruct.getResource("arrow"));

    public BulkQuiverModifier() {
        super(INVENTORY_KEY, 2);
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.BOW_AMMO);
    }

    @Override
    public int getPriority() {
        return 50;
    }

    @Override
    public boolean isItemValid(IToolStackView tool, ModifierEntry modifier, int slot, ItemStack stack) {
        Item item = stack.m_41720_();
        return item == Items.f_42688_ && tool.hasTag(TinkerTags.Items.CROSSBOWS) || stack.m_41720_() instanceof ArrowItem;
    }

    @Override
    @Nullable
    public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
        return hasStack ? null : ARROW;
    }

    @Override
    public ItemStack findAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack standardAmmo, Predicate<ItemStack> ammoPredicate) {
        ResourceLocation key;
        if (!standardAmmo.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ModDataNBT persistentData = tool.getPersistentData();
        ListTag slots = (ListTag)persistentData.get(key = this.getInventoryKey(), GET_COMPOUND_LIST);
        if (!slots.isEmpty()) {
            for (int i = 0; i < slots.size(); ++i) {
                CompoundTag compound = slots.m_128728_(i);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)compound);
                if (stack.m_41619_() || !ammoPredicate.test(stack)) continue;
                persistentData.putInt(LAST_SLOT, compound.m_128451_("Slot"));
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void shrinkAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, int needed) {
        ammo.m_41774_(needed);
        this.setStack(tool, modifier, tool.getPersistentData().getInt(LAST_SLOT), ammo);
    }
}

