/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.fluid;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.modules.fluid.TankModule;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluid;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluidManager;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableLauncherItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ability.interaction.BlockingModifier;
import slimeknights.tconstruct.tools.modifiers.upgrades.ranged.ScopeModifier;

public class SpittingModifier
extends Modifier
implements GeneralInteractionModifierHook {
    private TankModule tank;

    @Override
    protected void registerHooks(ModifierHookMap.Builder builder) {
        builder.addHook(this, TinkerHooks.CHARGEABLE_INTERACT);
        this.tank = new TankModule(1000, true);
        builder.addModule(this.tank);
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 72000;
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return BlockingModifier.blockWhileCharging(tool, UseAnim.BOW);
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        FluidStack fluid;
        if (!tool.isBroken() && source == InteractionSource.RIGHT_CLICK && (fluid = this.tank.getFluid(tool)).getAmount() >= 1 + 2 * (modifier.getLevel() - 1) && SpillingFluidManager.INSTANCE.contains(fluid.getFluid())) {
            ModifierUtil.startUsingItemWithDrawtime(tool, modifier.getId(), (LivingEntity)player, hand, 1.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
        ScopeModifier.scopingUsingTick(tool, entity, this.getUseDuration(tool, modifier) - timeLeft);
    }

    @Override
    public boolean onStoppedUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
        SpillingFluid recipe;
        FluidStack fluid;
        int chargeTime;
        ScopeModifier.stopScoping(entity);
        if (!entity.f_19853_.f_46443_ && (chargeTime = this.getUseDuration(tool, modifier) - timeLeft) > 0 && !(fluid = this.tank.getFluid(tool)).isEmpty() && (recipe = SpillingFluidManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            float charge = ModifierUtil.getToolCharge(tool, chargeTime);
            float power = charge * ConditionalStatModifierHook.getModifiedStat(tool, entity, ToolStats.PROJECTILE_DAMAGE);
            int level = modifier.getLevel();
            int amount = Math.min(fluid.getAmount(), (int)((float)recipe.getAmount(fluid) * power) * level) / level;
            if (amount > 0) {
                float velocity = ConditionalStatModifierHook.getModifiedStat(tool, entity, ToolStats.VELOCITY) * charge * 3.0f;
                float inaccuracy = ModifierUtil.getInaccuracy(tool, entity, velocity);
                int shots = 1 + 2 * (level - 1);
                float startAngle = ModifiableLauncherItem.getAngleStart(shots);
                int primaryIndex = shots / 2;
                for (int shotIndex = 0; shotIndex < shots; ++shotIndex) {
                    FluidSpitEntity spit = new FluidSpitEntity(entity.f_19853_, entity, new FluidStack(fluid, amount), (int)Math.ceil(power));
                    Vector3f targetVector = new Vector3f(entity.m_20252_(1.0f));
                    float angle = startAngle + (float)(10 * shotIndex);
                    targetVector.m_122251_(new Quaternion(new Vector3f(entity.m_20289_(1.0f)), angle, true));
                    spit.m_6686_(targetVector.m_122239_(), targetVector.m_122260_(), targetVector.m_122269_(), velocity, inaccuracy);
                    spit.getCapability(EntityModifierCapability.CAPABILITY).ifPresent(cap -> cap.setModifiers(tool.getModifiers()));
                    NamespacedNBT arrowData = PersistentDataCapability.getOrWarn((Entity)spit);
                    for (ModifierEntry entry : tool.getModifierList()) {
                        entry.getHook(TinkerHooks.PROJECTILE_LAUNCH).onProjectileLaunch(tool, entry, entity, (Projectile)spit, null, arrowData, shotIndex == primaryIndex);
                    }
                    entity.f_19853_.m_7967_((Entity)spit);
                    entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12098_, SoundSource.PLAYERS, 1.0f, 1.0f / (entity.f_19853_.m_5822_().nextFloat() * 0.4f + 1.2f) + charge * 0.5f + angle / 10.0f);
                }
                fluid.shrink(amount * level);
                this.tank.setFluid(tool, fluid);
                ToolDamageUtil.damageAnimated(tool, shots, entity, entity.m_7655_());
            }
        }
        return true;
    }

    public static class FluidSpitEntity
    extends LlamaSpit {
        private static final EntityDataAccessor<FluidStack> FLUID = SynchedEntityData.m_135353_(FluidSpitEntity.class, (EntityDataSerializer)TinkerFluids.FLUID_DATA_SERIALIZER);
        private int power = 1;
        private int knockback = 1;

        public FluidSpitEntity(EntityType<? extends FluidSpitEntity> type, Level level) {
            super(type, level);
        }

        public FluidSpitEntity(Level level, LivingEntity owner, FluidStack fluid, int power) {
            this((EntityType<? extends FluidSpitEntity>)((EntityType)TinkerModifiers.fluidSpitEntity.get()), level);
            this.m_6034_(owner.m_20185_(), owner.m_20188_() - 0.1, owner.m_20189_());
            this.m_5602_((Entity)owner);
            this.setFluid(fluid);
            this.setPower(power);
        }

        public FluidStack getFluid() {
            return (FluidStack)this.f_19804_.m_135370_(FLUID);
        }

        public void setFluid(FluidStack fluid) {
            this.f_19804_.m_135381_(FLUID, (Object)fluid);
        }

        protected void m_5790_(EntityHitResult result) {
            Entity entity;
            FluidStack fluid = this.getFluid();
            if (!this.f_19853_.f_46443_ && !fluid.isEmpty() && (entity = this.m_37282_()) instanceof LivingEntity) {
                Vec3 vec3;
                LivingEntity living = (LivingEntity)entity;
                SpillingFluid recipe = SpillingFluidManager.INSTANCE.find(fluid.getFluid());
                Entity target = result.m_82443_();
                if (recipe.hasEffects()) {
                    Player p;
                    recipe.applyEffects(fluid.copy(), this.power, new ToolAttackContext(living, living instanceof Player ? (p = (Player)living) : null, InteractionHand.MAIN_HAND, target, ToolAttackUtil.getLivingEntity(target), false, 1.0f, false));
                }
                if (this.knockback > 0 && (vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * 0.6)).m_82556_() > 0.0) {
                    target.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                }
            }
        }

        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(FLUID, (Object)FluidStack.EMPTY);
        }

        protected void m_7380_(CompoundTag nbt) {
            super.m_7380_(nbt);
            nbt.m_128405_("power", this.power);
            nbt.m_128405_("knockback", this.knockback);
            FluidStack fluid = this.getFluid();
            if (!fluid.isEmpty()) {
                nbt.m_128365_("fluid", (Tag)fluid.writeToNBT(new CompoundTag()));
            }
        }

        protected void m_7378_(CompoundTag nbt) {
            super.m_7378_(nbt);
            this.power = nbt.m_128451_("power");
            this.knockback = nbt.m_128451_("knockback");
            this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid")));
        }

        public void setPower(int power) {
            this.power = power;
        }

        public void setKnockback(int knockback) {
            this.knockback = knockback;
        }

        public int getKnockback() {
            return this.knockback;
        }
    }
}

