/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import slimeknights.mantle.recipe.data.FluidNameIngredient;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.tinkering.AbstractSpillingFluidProvider;
import slimeknights.tconstruct.library.json.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.predicate.entity.MobTypePredicate;
import slimeknights.tconstruct.library.modifiers.spilling.effects.AddBreathSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.AddInsomniaSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.CureEffectsSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.DamageSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.EffectSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.ExtinguishSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.PotionFluidEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.RemoveEffectSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.RestoreHungerSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.SetFireSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.SetFreezeSpillingEffect;
import slimeknights.tconstruct.library.modifiers.spilling.effects.TeleportSpillingEffect;
import slimeknights.tconstruct.library.recipe.TagPredicate;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.traits.skull.StrongBonesModifier;

public class SpillingFluidProvider
extends AbstractSpillingFluidProvider {
    public SpillingFluidProvider(DataGenerator generator) {
        super(generator, "tconstruct");
    }

    @Override
    protected void addFluids() {
        this.addFluid((Fluid)Fluids.f_76193_, 50).addEffect(LivingEntityPredicate.WATER_SENSITIVE, new DamageSpillingEffect(DamageSpillingEffect.DamageType.PIERCING, 2.0f)).addEffect(ExtinguishSpillingEffect.INSTANCE);
        this.addFluid((Fluid)Fluids.f_76195_, 50).addEffect(LivingEntityPredicate.FIRE_IMMUNE.inverted(), new DamageSpillingEffect(DamageSpillingEffect.DamageType.FIRE, 2.0f)).addEffect(new SetFireSpillingEffect(10));
        this.addFluid((TagKey<Fluid>)Tags.Fluids.MILK, 100).addEffect(new CureEffectsSpillingEffect(new ItemStack((ItemLike)Items.f_42455_))).addEffect(StrongBonesModifier.SPILLING_EFFECT);
        this.addFluid(TinkerTags.Fluids.POWDERED_SNOW, 100).addEffect(new SetFreezeSpillingEffect(160));
        this.burningFluid("blazing_blood", (TagKey<Fluid>)TinkerFluids.blazingBlood.getLocalTag(), 50, 3.0f, 5);
        int slimeballPiece = 50;
        this.addFluid((TagKey<Fluid>)TinkerFluids.earthSlime.getForgeTag(), slimeballPiece).addEffect(new EffectSpillingEffect(MobEffects.f_19621_, 15, 1)).addEffect(new EffectSpillingEffect(MobEffects.f_19597_, 15, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.skySlime.getLocalTag(), slimeballPiece).addEffect(new EffectSpillingEffect(MobEffects.f_19603_, 20, 1)).addEffect(new EffectSpillingEffect(MobEffects.f_19597_, 15, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.enderSlime.getLocalTag(), slimeballPiece).addEffect(new EffectSpillingEffect(MobEffects.f_19620_, 5, 1)).addEffect(new EffectSpillingEffect(MobEffects.f_19597_, 15, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.blood.getLocalTag(), slimeballPiece).addEffect(new RestoreHungerSpillingEffect(1, 0.2f, ItemOutput.fromItem((ItemLike)((ItemLike)TinkerFluids.slimeBottle.get((Enum)SlimeType.BLOOD))))).addEffect(new EffectSpillingEffect(MobEffects.f_19599_, 10, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.venom.getLocalTag(), slimeballPiece).addEffect(new EffectSpillingEffect(MobEffects.f_19614_, 5, 1)).addEffect(new EffectSpillingEffect(MobEffects.f_19600_, 10, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.magma.getForgeTag(), slimeballPiece).addEffect(new EffectSpillingEffect(MobEffects.f_19607_, 25, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.liquidSoul.getLocalTag(), 50).addEffect(new EffectSpillingEffect(MobEffects.f_19597_, 25, 2)).addEffect(new EffectSpillingEffect(MobEffects.f_19610_, 5, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenEnder.getForgeTag(), 50).addEffect(new DamageSpillingEffect(DamageSpillingEffect.DamageType.MAGIC, 1.0f)).addEffect(TeleportSpillingEffect.INSTANCE);
        this.addFluid((TagKey<Fluid>)TinkerFluids.honey.getForgeTag(), slimeballPiece).addEffect(new RestoreHungerSpillingEffect(1, 0.02f, ItemOutput.fromItem((ItemLike)Items.f_42787_))).addEffect(new RemoveEffectSpillingEffect(MobEffects.f_19614_));
        this.addFluid((TagKey<Fluid>)TinkerFluids.beetrootSoup.getForgeTag(), slimeballPiece).addEffect(new RestoreHungerSpillingEffect(1, 0.15f, ItemOutput.fromItem((ItemLike)Items.f_42734_)));
        this.addFluid((TagKey<Fluid>)TinkerFluids.mushroomStew.getForgeTag(), slimeballPiece).addEffect(new RestoreHungerSpillingEffect(1, 0.15f, ItemOutput.fromItem((ItemLike)Items.f_42400_)));
        this.addFluid((TagKey<Fluid>)TinkerFluids.rabbitStew.getForgeTag(), slimeballPiece).addEffect(new RestoreHungerSpillingEffect(2, 0.1f, ItemOutput.fromItem((ItemLike)Items.f_42699_)));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenPigIron.getLocalTag(), 10).addEffect(new RestoreHungerSpillingEffect(2, 0.3f, ItemOutput.fromItem(TinkerCommons.bacon))).addEffect(new SetFireSpillingEffect(2));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenIron.getForgeTag(), 2.0f).addEffect(new EffectSpillingEffect((MobEffect)TinkerModifiers.magneticEffect.get(), 4, 2));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenSteel.getForgeTag(), 2.0f).addEffect(new EffectSpillingEffect((MobEffect)TinkerModifiers.repulsiveEffect.get(), 4, 2));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenCopper.getForgeTag(), 1.5f).addEffect(new AddBreathSpillingEffect(80));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenBronze.getForgeTag(), 2.0f).addEffect(new AddInsomniaSpillingEffect(-2000));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenAmethystBronze.getLocalTag(), 1.5f).addEffect(new AddInsomniaSpillingEffect(2000));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenZinc.getForgeTag(), 1.5f).addEffect(new EffectSpillingEffect(MobEffects.f_19596_, 10, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenBrass.getForgeTag(), 2.0f).addEffect(new EffectSpillingEffect(MobEffects.f_19607_, 8, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenTin.getForgeTag(), 1.5f).addEffect(new EffectSpillingEffect(MobEffects.f_19611_, 8, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenPewter.getForgeTag(), 2.0f).addEffect(new EffectSpillingEffect(MobEffects.f_19600_, 7, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenGold.getForgeTag(), 10).addEffect(new MobTypePredicate(MobType.f_21641_), new DamageSpillingEffect(DamageSpillingEffect.DamageType.MAGIC, 2.0f)).addEffect(new EffectSpillingEffect(MobEffects.f_19605_, 6, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenElectrum.getForgeTag(), 10).addEffect(new MobTypePredicate(MobType.f_21641_), new DamageSpillingEffect(DamageSpillingEffect.DamageType.MAGIC, 2.0f)).addEffect(new EffectSpillingEffect(MobEffects.f_19598_, 8, 1));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenRoseGold.getForgeTag(), 10).addEffect(new MobTypePredicate(MobType.f_21641_), new DamageSpillingEffect(DamageSpillingEffect.DamageType.MAGIC, 2.0f)).addEffect(new EffectSpillingEffect(MobEffects.f_19616_, 15, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenAluminum.getForgeTag(), 1.0f).addEffect(new CureEffectsSpillingEffect(new ItemStack((ItemLike)Items.f_42455_)));
        this.addFluid((TagKey<Fluid>)TinkerFluids.moltenSilver.getForgeTag(), 10).addEffect(new MobTypePredicate(MobType.f_21641_), new DamageSpillingEffect(DamageSpillingEffect.DamageType.MAGIC, 2.0f)).addEffect(new RemoveEffectSpillingEffect(MobEffects.f_19615_));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenLead.getForgeTag(), 1.5f).addEffect(new EffectSpillingEffect(MobEffects.f_19597_, 6, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenNickel.getForgeTag(), 1.5f).addEffect(new EffectSpillingEffect(MobEffects.f_19613_, 7, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenInvar.getForgeTag(), 2.0f).addEffect(new EffectSpillingEffect(MobEffects.f_19612_, 10, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenConstantan.getForgeTag(), 2.0f).addEffect(new EffectSpillingEffect(MobEffects.f_19612_, 10, 1));
        this.burningFluid((TagKey<Fluid>)TinkerFluids.moltenUranium.getForgeTag(), 1.5f, 3).addEffect(new EffectSpillingEffect(MobEffects.f_19614_, 10, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenCobalt.getForgeTag(), 1.0f).addEffect(new EffectSpillingEffect(MobEffects.f_19598_, 7, 1)).addEffect(new EffectSpillingEffect(MobEffects.f_19596_, 7, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenManyullyn.getForgeTag(), 3.0f).addEffect(new EffectSpillingEffect(MobEffects.f_19606_, 15, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenHepatizon.getForgeTag(), 2.5f).addEffect(new EffectSpillingEffect(MobEffects.f_19606_, 10, 1));
        this.burningFluid((TagKey<Fluid>)TinkerFluids.moltenNetherite.getForgeTag(), 3.5f, 4).addEffect(new EffectSpillingEffect(MobEffects.f_19610_, 15, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenSlimesteel.getLocalTag(), 1.0f).addEffect(new EffectSpillingEffect(MobEffects.f_19591_, 5, 1));
        this.metalborn((TagKey<Fluid>)TinkerFluids.moltenQueensSlime.getLocalTag(), 1.0f).addEffect(new EffectSpillingEffect(MobEffects.f_19620_, 5, 1));
        this.burningFluid("glass", TinkerTags.Fluids.GLASS_SPILLING, 100, 1.0f, 3);
        this.burningFluid("clay", TinkerTags.Fluids.CLAY_SPILLING, 50, 1.5f, 3);
        this.burningFluid("metal_cheap", TinkerTags.Fluids.CHEAP_METAL_SPILLING, 10, 1.5f, 7);
        this.burningFluid("metal_average", TinkerTags.Fluids.AVERAGE_METAL_SPILLING, 10, 2.0f, 7);
        this.burningFluid("metal_expensive", TinkerTags.Fluids.EXPENSIVE_METAL_SPILLING, 10, 3.0f, 7);
        int bottleSip = 50;
        this.addFluid("potion_fluid", TinkerTags.Fluids.POTION, bottleSip).addEffect(new PotionFluidEffect(0.25f, TagPredicate.ANY));
        Function<String, TagPredicate> createBottle = value -> {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("Bottle", value);
            return new TagPredicate(compound);
        };
        String create = "create";
        this.addFluid("potion_create", (FluidIngredient)FluidNameIngredient.of((ResourceLocation)new ResourceLocation(create, "potion"), (int)bottleSip)).condition((ICondition)new ModLoadedCondition(create)).addEffect(new PotionFluidEffect(0.25f, createBottle.apply("REGULAR"))).addEffect(new PotionFluidEffect(0.5f, createBottle.apply("SPLASH"))).addEffect(new PotionFluidEffect(0.75f, createBottle.apply("LINGERING")));
    }

    private AbstractSpillingFluidProvider.Builder metalborn(TagKey<Fluid> tag, float damage) {
        return this.burningFluid(tag.f_203868_().m_135815_(), tag, 10, damage, 0);
    }

    public String m_6055_() {
        return "Tinkers' Construct Spilling Fluid Provider";
    }
}

