/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.table;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.inventory.LazyResultContainer;
import slimeknights.tconstruct.tables.block.entity.inventory.ModifierWorktableContainerWrapper;
import slimeknights.tconstruct.tables.block.entity.table.RetexturedTableBlockEntity;
import slimeknights.tconstruct.tables.menu.ModifierWorktableContainerMenu;

public class ModifierWorktableBlockEntity
extends RetexturedTableBlockEntity
implements LazyResultContainer.ILazyCrafter {
    public static final int TINKER_SLOT = 0;
    public static final int INPUT_START = 1;
    public static final int INPUT_COUNT = 2;
    private static final Component NAME = TConstruct.makeTranslation("gui", "modifier_worktable");
    private final LazyResultContainer craftingResult;
    private final ModifierWorktableContainerWrapper inventoryWrapper;
    private Boolean recipeValid;
    @Nullable
    private IModifierWorktableRecipe lastRecipe;
    @Nonnull
    private List<ModifierEntry> buttons = Collections.emptyList();
    private int selectedModifierIndex = -1;
    @Nullable
    private ToolStack result = null;
    private Component currentMessage = TextComponent.f_131282_;

    public ModifierWorktableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TinkerTables.modifierWorktableTile.get(), pos, state, NAME, 3);
        this.itemHandler = new ConfigurableInvWrapperCapability((Container)this, false, false);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
        this.inventoryWrapper = new ModifierWorktableContainerWrapper(this);
        this.craftingResult = new LazyResultContainer(this);
    }

    public void selectModifier(int index) {
        List<ModifierEntry> list;
        this.result = null;
        this.craftingResult.m_6211_();
        if (index >= 0 && index < (list = this.getCurrentButtons()).size()) {
            this.selectedModifierIndex = index;
            ModifierEntry entry = list.get(index);
            assert (this.lastRecipe != null);
            RecipeResult<ToolStack> recipeResult = this.lastRecipe.getResult(this.inventoryWrapper, entry);
            if (recipeResult.isSuccess()) {
                this.result = recipeResult.getResult();
                this.currentMessage = TextComponent.f_131282_;
            } else {
                this.currentMessage = recipeResult.hasError() ? recipeResult.getMessage() : this.lastRecipe.getDescription(this.inventoryWrapper);
            }
            return;
        }
        this.selectedModifierIndex = -1;
        this.currentMessage = this.recipeValid == Boolean.TRUE && this.lastRecipe != null ? this.lastRecipe.getDescription(this.inventoryWrapper) : TextComponent.f_131282_;
    }

    public int getSelectedIndex() {
        return this.selectedModifierIndex;
    }

    public IModifierWorktableRecipe updateRecipe(IModifierWorktableRecipe recipe) {
        this.lastRecipe = recipe;
        this.recipeValid = true;
        this.currentMessage = this.lastRecipe.getDescription(this.inventoryWrapper);
        this.buttons = recipe.getModifierOptions(this.inventoryWrapper);
        this.selectModifier(-1);
        return recipe;
    }

    @Nullable
    public IModifierWorktableRecipe getCurrentRecipe() {
        if (this.recipeValid == Boolean.TRUE) {
            return this.lastRecipe;
        }
        if (this.recipeValid == null && this.f_58857_ != null) {
            if (this.lastRecipe != null && this.lastRecipe.matches(this.inventoryWrapper, this.f_58857_)) {
                return this.updateRecipe(this.lastRecipe);
            }
            Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)TinkerRecipeTypes.MODIFIER_WORKTABLE.get(), (Container)this.inventoryWrapper, this.f_58857_);
            if (recipe.isPresent()) {
                return this.updateRecipe((IModifierWorktableRecipe)recipe.get());
            }
            this.recipeValid = false;
            this.currentMessage = TextComponent.f_131282_;
            this.buttons = Collections.emptyList();
            this.selectModifier(-1);
        }
        return null;
    }

    public List<ModifierEntry> getCurrentButtons() {
        if (this.f_58857_ == null) {
            return Collections.emptyList();
        }
        this.getCurrentRecipe();
        return this.buttons;
    }

    public void onSlotChanged(int slot) {
        this.inventoryWrapper.refreshInput(slot);
        this.recipeValid = null;
        this.buttons = Collections.emptyList();
        this.selectModifier(-1);
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        ItemStack original = this.m_8020_(slot);
        super.m_6836_(slot, stack);
        if (original.m_41613_() != stack.m_41613_() || !ItemStack.m_150942_((ItemStack)original, (ItemStack)stack)) {
            this.onSlotChanged(slot);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int menuId, Inventory playerInventory, Player playerEntity) {
        return new ModifierWorktableContainerMenu(menuId, playerInventory, this);
    }

    @Override
    public ItemStack calcResult(@Nullable Player player) {
        IModifierWorktableRecipe recipe;
        if (this.selectedModifierIndex != -1 && (recipe = this.getCurrentRecipe()) != null && this.result != null) {
            return this.result.createStack(recipe.toolResultSize(this.inventoryWrapper, this.getCurrentButtons().get(this.selectedModifierIndex)));
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void onCraft(Player player, ItemStack resultItem, int amount) {
        if (amount == 0 || this.f_58857_ == null || this.lastRecipe == null || this.result == null) {
            return;
        }
        resultItem.m_41678_(this.f_58857_, player, amount);
        ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)resultItem, (Container)this.inventoryWrapper);
        this.playCraftSound(player);
        this.inventoryWrapper.setPlayer(player);
        this.lastRecipe.updateInputs(this.result, this.inventoryWrapper, this.getCurrentButtons().get(this.selectedModifierIndex), !this.f_58857_.f_46443_);
        this.inventoryWrapper.setPlayer(null);
        ItemStack tinkerable = this.m_8020_(0);
        if (!tinkerable.m_41619_()) {
            int shrinkToolSlot = this.lastRecipe.toolResultSize();
            if (tinkerable.m_41613_() <= shrinkToolSlot) {
                this.m_6836_(0, ItemStack.f_41583_);
            } else {
                this.m_6836_(0, ItemHandlerHelper.copyStackWithSize((ItemStack)tinkerable, (int)(tinkerable.m_41613_() - shrinkToolSlot)));
            }
        }
    }

    public LazyResultContainer getCraftingResult() {
        return this.craftingResult;
    }

    public ModifierWorktableContainerWrapper getInventoryWrapper() {
        return this.inventoryWrapper;
    }

    @Nullable
    public ToolStack getResult() {
        return this.result;
    }

    public Component getCurrentMessage() {
        return this.currentMessage;
    }
}

