/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.LanternBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;

public class SearedLanternBlock
extends LanternBlock
implements TankBlockEntity.ITankBlock,
EntityBlock {
    private final int capacity;

    public SearedLanternBlock(BlockBehaviour.Properties properties, int capacity) {
        super(properties);
        this.capacity = capacity;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LanternBlockEntity(pos, state, this);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TankBlockEntity) {
            FluidStack fluid = ((TankBlockEntity)te).getTank().getFluid();
            return fluid.getFluid().getAttributes().getLuminosity(fluid);
        }
        return 0;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            BlockEntityHelper.get(TankBlockEntity.class, (BlockGetter)worldIn, (BlockPos)pos).ifPresent(te -> te.updateTank(nbt.m_128469_("tank")));
        }
    }

    @Deprecated
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return ITankBlockEntity.getComparatorInputOverride((LevelAccessor)worldIn, pos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntityHelper.get(TankBlockEntity.class, (BlockGetter)world, (BlockPos)pos).ifPresent(te -> te.setTankTag(stack));
        return stack;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }
}

