/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record StatPredicate(INumericToolStat<?> stat, float min, float max) implements Predicate<StatsNBT>,
ToolContextPredicate
{
    public static final GenericLoaderRegistry.IGenericLoader<StatPredicate> LOADER = new GenericLoaderRegistry.IGenericLoader<StatPredicate>(){

        public StatPredicate deserialize(JsonObject json) {
            return StatPredicate.deserialize(json);
        }

        public void serialize(StatPredicate object, JsonObject json) {
            object.serialize(json);
        }

        public StatPredicate fromNetwork(FriendlyByteBuf buffer) {
            INumericToolStat<?> stat = ToolStats.numericFromNetwork(buffer);
            float min = buffer.readFloat();
            float max = buffer.readFloat();
            return new StatPredicate(stat, min, max);
        }

        public void toNetwork(StatPredicate object, FriendlyByteBuf buffer) {
            buffer.m_130070_(object.stat.getName().toString());
            buffer.writeFloat(object.min);
            buffer.writeFloat(object.max);
        }
    };

    public static StatPredicate match(INumericToolStat<?> stat, float value) {
        return new StatPredicate(stat, value, value);
    }

    public static StatPredicate min(INumericToolStat<?> stat, float min) {
        return new StatPredicate(stat, min, Float.POSITIVE_INFINITY);
    }

    public static StatPredicate max(INumericToolStat<?> stat, float max) {
        return new StatPredicate(stat, Float.NEGATIVE_INFINITY, max);
    }

    @Override
    public boolean test(StatsNBT statsNBT) {
        float value = ((Number)statsNBT.get(this.stat)).floatValue();
        return value >= this.min && value <= this.max;
    }

    public boolean matches(IToolContext tool) {
        return this.test(tool.getStats());
    }

    public static StatPredicate deserialize(JsonObject json) {
        return new StatPredicate(ToolStats.numericFromJson(GsonHelper.m_13906_((JsonObject)json, (String)"stat")), GsonHelper.m_13820_((JsonObject)json, (String)"min", (float)Float.NEGATIVE_INFINITY), GsonHelper.m_13820_((JsonObject)json, (String)"max", (float)Float.POSITIVE_INFINITY));
    }

    public JsonObject serialize(JsonObject json) {
        json.addProperty("stat", this.stat.getName().toString());
        if (this.min > Float.NEGATIVE_INFINITY) {
            json.addProperty("min", (Number)Float.valueOf(this.min));
        }
        if (this.max < Float.POSITIVE_INFINITY) {
            json.addProperty("max", (Number)Float.valueOf(this.max));
        }
        return json;
    }

    public JsonObject serialize() {
        return this.serialize(new JsonObject());
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<IToolContext>> getLoader() {
        return LOADER;
    }
}

