/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.part;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.part.MaterialItem;

public class ToolPartItem
extends MaterialItem
implements IToolPart {
    private static final Component MISSING_INFO = TConstruct.makeTranslation("tooltip", "part.missing_info");
    private static final String MISSING_MATERIAL_KEY = TConstruct.makeTranslationKey("tooltip", "part.missing_material");
    private static final String MISSING_STATS_KEY = TConstruct.makeTranslationKey("tooltip", "part.missing_stats");
    public static final String MATERIAL_KEY = TConstruct.makeTranslationKey("tooltip", "part.material_id");
    public final MaterialStatsId materialStatId;

    public ToolPartItem(Item.Properties properties, MaterialStatsId id) {
        super(properties);
        this.materialStatId = id;
    }

    @Override
    public MaterialStatsId getStatType() {
        return this.materialStatId;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        if (TooltipUtil.isDisplay(stack)) {
            return;
        }
        MaterialVariantId materialVariant = this.getMaterial(stack);
        MaterialId id = materialVariant.getId();
        if (!materialVariant.equals(IMaterial.UNKNOWN_ID)) {
            if (flag.m_7050_()) {
                tooltip.add((Component)new TranslatableComponent(MATERIAL_KEY, new Object[]{materialVariant.toString()}).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (this.canUseMaterial(id)) {
                for (ModifierEntry entry : MaterialRegistry.getInstance().getTraits(id, this.getStatType())) {
                    Component name = entry.getModifier().getDisplayName(entry.getLevel());
                    if (flag.m_7050_() && ((Boolean)Config.CLIENT.modifiersIDsInAdvancedTooltips.get()).booleanValue()) {
                        tooltip.add((Component)new TranslatableComponent(TooltipUtil.KEY_ID_FORMAT, new Object[]{name, new TextComponent(entry.getModifier().getId().toString())}).m_130940_(ChatFormatting.DARK_GRAY));
                        continue;
                    }
                    tooltip.add(name);
                }
                if (((Boolean)Config.CLIENT.extraToolTips.get()).booleanValue()) {
                    TooltipKey key = SafeClientAccess.getTooltipKey();
                    if (key == TooltipKey.SHIFT || key == TooltipKey.UNKNOWN) {
                        this.addStatInfoTooltip(id, tooltip);
                    } else {
                        tooltip.add(TextComponent.f_131282_);
                        tooltip.add(TooltipUtil.TOOLTIP_HOLD_SHIFT);
                    }
                }
            } else {
                IMaterial material = MaterialRegistry.getMaterial(id);
                if (material == IMaterial.UNKNOWN) {
                    tooltip.add((Component)new TranslatableComponent(MISSING_MATERIAL_KEY, new Object[]{id}));
                } else {
                    tooltip.add((Component)new TranslatableComponent(MISSING_STATS_KEY, new Object[]{this.materialStatId}).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    protected void addStatInfoTooltip(MaterialId material, List<Component> tooltip) {
        MaterialRegistry.getInstance().getMaterialStats(material, this.materialStatId).ifPresent(stat -> {
            List<Component> text = stat.getLocalizedInfo();
            if (!text.isEmpty()) {
                tooltip.add(TextComponent.f_131282_);
                tooltip.add((Component)stat.getLocalizedName().m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE}));
                tooltip.addAll(stat.getLocalizedInfo());
            }
        });
    }
}

