/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.tools.TinkerTools;

public class IndestructibleItemEntity
extends ItemEntity {
    public IndestructibleItemEntity(EntityType<? extends IndestructibleItemEntity> entityType, Level world) {
        super(entityType, world);
        this.lifespan = Integer.MAX_VALUE;
    }

    public IndestructibleItemEntity(Level worldIn, double x, double y, double z, ItemStack stack) {
        this((EntityType<? extends IndestructibleItemEntity>)((EntityType)TinkerTools.indestructibleItem.get()), worldIn);
        this.m_6034_(x, y, z);
        this.m_146922_(this.f_19796_.nextFloat() * 360.0f);
        this.m_20334_(this.f_19796_.nextDouble() * 0.2 - 0.1, 0.2, this.f_19796_.nextDouble() * 0.2 - 0.1);
        this.m_32045_(stack);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setPickupDelayFrom(Entity reference) {
        if (reference instanceof ItemEntity) {
            short pickupDelay = this.getPickupDelay((ItemEntity)reference);
            this.m_32010_(pickupDelay);
        }
        this.m_20256_(reference.m_20184_());
    }

    private short getPickupDelay(ItemEntity reference) {
        CompoundTag tag = new CompoundTag();
        reference.m_7380_(tag);
        return tag.m_128448_("PickupDelay");
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return source.m_19385_().equals(DamageSource.f_19317_.f_19326_);
    }

    public static boolean hasCustomEntity(ItemStack stack) {
        return ModifierUtil.checkVolatileFlag(stack, IModifiable.INDESTRUCTIBLE_ENTITY);
    }

    @Nullable
    public static Entity createFrom(Level world, Entity original, ItemStack stack) {
        if (ModifierUtil.checkVolatileFlag(stack, IModifiable.INDESTRUCTIBLE_ENTITY)) {
            IndestructibleItemEntity entity = new IndestructibleItemEntity(world, original.m_20185_(), original.m_20186_(), original.m_20189_(), stack);
            entity.setPickupDelayFrom(original);
            return entity;
        }
        return null;
    }
}

