/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierRepairRecipeSerializer;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRepairCraftingRecipe
extends CustomRecipe
implements ModifierRepairRecipeSerializer.IModifierRepairRecipe {
    private final ModifierId modifier;
    private final Ingredient ingredient;
    private final int repairAmount;

    public ModifierRepairCraftingRecipe(ResourceLocation idIn, ModifierId modifier, Ingredient ingredient, int repairAmount) {
        super(idIn);
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    @Nullable
    protected Pair<ToolStack, Integer> getRelevantInputs(CraftingContainer inv) {
        ToolStack tool = null;
        int itemsFound = 0;
        int modifierLevel = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_204117_(TinkerTags.Items.DURABILITY)) {
                if (tool != null) {
                    return null;
                }
                tool = ToolStack.from(stack);
                if (!tool.isBroken() && tool.getDamage() == 0) {
                    return null;
                }
                modifierLevel = tool.getModifierLevel(this.modifier);
                if (modifierLevel != 0) continue;
                return null;
            }
            if (this.ingredient.test(stack)) {
                ++itemsFound;
                continue;
            }
            return null;
        }
        if (tool == null || itemsFound == 0) {
            return null;
        }
        return Pair.of(tool, (Object)(this.repairAmount * itemsFound * modifierLevel));
    }

    public boolean matches(CraftingContainer inv, Level world) {
        return this.getRelevantInputs(inv) != null;
    }

    public ItemStack assemble(CraftingContainer inv) {
        Pair<ToolStack, Integer> inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            TConstruct.LOG.error("Recipe repair on {} failed to find items after matching", (Object)this.m_6423_());
            return ItemStack.f_41583_;
        }
        float repairAmount = ((Integer)inputs.getSecond()).intValue();
        ToolStack tool = (ToolStack)inputs.getFirst();
        for (ModifierEntry entry : tool.getModifierList()) {
            repairAmount = entry.getHook(TinkerHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairAmount);
            if (!(repairAmount <= 0.0f)) continue;
            return ItemStack.f_41583_;
        }
        tool = tool.copy();
        ToolDamageUtil.repair(tool, (int)repairAmount);
        return tool.createStack();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        Pair<ToolStack, Integer> inputs = this.getRelevantInputs(inv);
        int repairPerItem = 0;
        int repairNeeded = 0;
        if (inputs != null) {
            ToolStack tool = (ToolStack)inputs.getFirst();
            repairNeeded = tool.getDamage();
            float repairFloat = tool.getModifierLevel(this.modifier) * this.repairAmount;
            if (repairFloat > 0.0f) {
                ModifierEntry entry;
                Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
                while (iterator.hasNext() && !((repairFloat = (entry = iterator.next()).getHook(TinkerHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairFloat)) <= 0.0f)) {
                }
                repairPerItem = (int)repairFloat;
            }
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (this.ingredient.test(stack)) {
                if (repairNeeded <= 0) continue;
                repairNeeded -= repairPerItem;
            }
            if (!stack.hasContainerItem()) continue;
            list.set(i, (Object)stack.getContainerItem());
        }
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.craftingModifierRepair.get();
    }

    @Override
    public ModifierId getModifier() {
        return this.modifier;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getRepairAmount() {
        return this.repairAmount;
    }
}

