/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.tables.TinkerTables;

public class ItemPartRecipeBuilder
extends AbstractRecipeBuilder<ItemPartRecipeBuilder> {
    private final ResourceLocation pattern;
    private final ItemOutput result;
    private Ingredient patternItem;
    private MaterialId materialId = IMaterial.UNKNOWN_ID;
    private int cost = 0;

    @Deprecated
    public static ItemPartRecipeBuilder item(MaterialId material, ResourceLocation pattern, int cost, ItemOutput result) {
        return ItemPartRecipeBuilder.item(pattern, result).material(material, cost);
    }

    public ItemPartRecipeBuilder material(MaterialId material, int cost) {
        this.materialId = material;
        this.cost = cost;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Objects.requireNonNull(this.result.get().m_41720_().getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "parts");
        consumer.accept((FinishedRecipe)new Finished(id, advancementId));
    }

    private ItemPartRecipeBuilder(ResourceLocation pattern, ItemOutput result) {
        this.pattern = pattern;
        this.result = result;
    }

    public static ItemPartRecipeBuilder item(ResourceLocation pattern, ItemOutput result) {
        return new ItemPartRecipeBuilder(pattern, result);
    }

    public ItemPartRecipeBuilder setPatternItem(Ingredient patternItem) {
        this.patternItem = patternItem;
        return this;
    }

    private class Finished
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)ItemPartRecipeBuilder.this, ID, advancementID);
        }

        public void m_7917_(JsonObject json) {
            if (!ItemPartRecipeBuilder.this.materialId.equals(IMaterial.UNKNOWN_ID)) {
                json.addProperty("material", ItemPartRecipeBuilder.this.materialId.toString());
            }
            json.addProperty("pattern", ItemPartRecipeBuilder.this.pattern.toString());
            if (ItemPartRecipeBuilder.this.patternItem != null) {
                json.add("pattern_item", ItemPartRecipeBuilder.this.patternItem.m_43942_());
            }
            if (ItemPartRecipeBuilder.this.cost > 0) {
                json.addProperty("cost", (Number)ItemPartRecipeBuilder.this.cost);
            }
            json.add("result", ItemPartRecipeBuilder.this.result.serialize());
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerTables.itemPartBuilderSerializer.get();
        }
    }
}

