/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.recipe.casting.PotionCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class PotionCastingRecipeBuilder
extends AbstractRecipeBuilder<PotionCastingRecipeBuilder> {
    private final Item result;
    private final PotionCastingRecipe.Serializer recipeSerializer;
    private Ingredient bottle = Ingredient.f_43901_;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int coolingTime = 0;

    public static PotionCastingRecipeBuilder basinRecipe(ItemLike result) {
        return PotionCastingRecipeBuilder.castingRecipe(result.m_5456_(), (PotionCastingRecipe.Serializer)((Object)TinkerSmeltery.basinPotionRecipeSerializer.get()));
    }

    public static PotionCastingRecipeBuilder tableRecipe(ItemLike result) {
        return PotionCastingRecipeBuilder.castingRecipe(result.m_5456_(), (PotionCastingRecipe.Serializer)((Object)TinkerSmeltery.tablePotionRecipeSerializer.get()));
    }

    public PotionCastingRecipeBuilder setFluid(TagKey<Fluid> tagIn, int amount) {
        return this.setFluid(FluidIngredient.of(tagIn, (int)amount));
    }

    public PotionCastingRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public PotionCastingRecipeBuilder setBottle(TagKey<Item> tagIn) {
        return this.setBottle(Ingredient.m_204132_(tagIn));
    }

    public PotionCastingRecipeBuilder setBottle(ItemLike itemIn) {
        return this.setBottle(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
    }

    public PotionCastingRecipeBuilder setBottle(Ingredient ingredient) {
        this.bottle = ingredient;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, Objects.requireNonNull(this.result.getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Casting recipes require a fluid input");
        }
        if (this.coolingTime < 0) {
            throw new IllegalStateException("Cooling time is too low, must be at least 0");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept((FinishedRecipe)new Result(id, advancementId));
    }

    private PotionCastingRecipeBuilder(Item result, PotionCastingRecipe.Serializer recipeSerializer) {
        this.result = result;
        this.recipeSerializer = recipeSerializer;
    }

    public static PotionCastingRecipeBuilder castingRecipe(Item result, PotionCastingRecipe.Serializer recipeSerializer) {
        return new PotionCastingRecipeBuilder(result, recipeSerializer);
    }

    public PotionCastingRecipeBuilder setCoolingTime(int coolingTime) {
        this.coolingTime = coolingTime;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)PotionCastingRecipeBuilder.this, ID, advancementID);
        }

        public RecipeSerializer<?> m_6637_() {
            return PotionCastingRecipeBuilder.this.recipeSerializer;
        }

        public void m_7917_(JsonObject json) {
            if (!PotionCastingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", PotionCastingRecipeBuilder.this.group);
            }
            if (PotionCastingRecipeBuilder.this.bottle != Ingredient.f_43901_) {
                json.add("bottle", PotionCastingRecipeBuilder.this.bottle.m_43942_());
            }
            json.add("fluid", PotionCastingRecipeBuilder.this.fluid.serialize());
            json.addProperty("result", Objects.requireNonNull(PotionCastingRecipeBuilder.this.result.getRegistryName()).toString());
            json.addProperty("cooling_time", (Number)PotionCastingRecipeBuilder.this.coolingTime);
        }
    }
}

