/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;

public class PotionCastingRecipe
implements ICastingRecipe,
IMultiRecipe<DisplayCastingRecipe> {
    private final RecipeType<?> type;
    private final RecipeSerializer<?> serializer;
    private final ResourceLocation id;
    private final String group;
    private final Ingredient bottle;
    private final FluidIngredient fluid;
    private final Item result;
    private final int coolingTime;
    private List<DisplayCastingRecipe> displayRecipes = null;

    public boolean matches(ICastingContainer inv, Level level) {
        return this.bottle.test(inv.getStack()) && this.fluid.test(inv.getFluid());
    }

    @Override
    public int getFluidAmount(ICastingContainer inv) {
        return this.fluid.getAmount(inv.getFluid());
    }

    @Override
    public boolean isConsumed() {
        return true;
    }

    @Override
    public boolean switchSlots() {
        return false;
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return this.coolingTime;
    }

    public ItemStack assemble(ICastingContainer inv) {
        ItemStack result = new ItemStack((ItemLike)this.result);
        result.m_41751_(inv.getFluidTag());
        return result;
    }

    public List<DisplayCastingRecipe> getRecipes() {
        if (this.displayRecipes == null) {
            List<ItemStack> bottles = List.of(this.bottle.m_43908_());
            this.displayRecipes = ForgeRegistries.POTIONS.getValues().stream().map(potion -> {
                ItemStack result = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)this.result), (Potion)potion);
                return new DisplayCastingRecipe(this.type, bottles, this.fluid.getFluids().stream().map(fluid -> new FluidStack(fluid.getFluid(), fluid.getAmount(), result.m_41783_())).toList(), result, this.coolingTime, true);
            }).toList();
        }
        return this.displayRecipes;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.bottle});
    }

    @Deprecated
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.result);
    }

    public PotionCastingRecipe(RecipeType<?> type, RecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient bottle, FluidIngredient fluid, Item result, int coolingTime) {
        this.type = type;
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.bottle = bottle;
        this.fluid = fluid;
        this.result = result;
        this.coolingTime = coolingTime;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<PotionCastingRecipe> {
        private final Supplier<RecipeType<ICastingRecipe>> type;

        public PotionCastingRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient bottle = Ingredient.m_43917_((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"bottle"));
            FluidIngredient fluid = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            Item result = (Item)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.ITEMS, (JsonObject)json, (String)"result");
            int coolingTime = GsonHelper.m_13927_((JsonObject)json, (String)"cooling_time");
            return new PotionCastingRecipe(this.type.get(), (RecipeSerializer<?>)this, id, group, bottle, fluid, result, coolingTime);
        }

        @Nullable
        protected PotionCastingRecipe fromNetworkSafe(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient bottle = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidIngredient fluid = FluidIngredient.read((FriendlyByteBuf)buffer);
            Item result = (Item)buffer.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
            int coolingTime = buffer.m_130242_();
            return new PotionCastingRecipe(this.type.get(), (RecipeSerializer<?>)this, id, group, bottle, fluid, result, coolingTime);
        }

        protected void toNetworkSafe(FriendlyByteBuf buffer, PotionCastingRecipe recipe) {
            buffer.m_130070_(recipe.group);
            recipe.bottle.m_43923_(buffer);
            recipe.fluid.write(buffer);
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (IForgeRegistryEntry)recipe.result);
            buffer.m_130130_(recipe.coolingTime);
        }

        public Serializer(Supplier<RecipeType<ICastingRecipe>> type) {
            this.type = type;
        }
    }
}

