/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class ItemCastingRecipeBuilder
extends AbstractRecipeBuilder<ItemCastingRecipeBuilder> {
    private final ItemOutput result;
    private final ItemCastingRecipe.Serializer<?> recipeSerializer;
    private Ingredient cast = Ingredient.f_43901_;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int coolingTime = -1;
    private boolean consumed = false;
    private boolean switchSlots = false;

    public static ItemCastingRecipeBuilder basinRecipe(ItemOutput result) {
        return ItemCastingRecipeBuilder.castingRecipe(result, (ItemCastingRecipe.Serializer)((Object)TinkerSmeltery.basinRecipeSerializer.get()));
    }

    public static ItemCastingRecipeBuilder retexturedBasinRecipe(ItemOutput result) {
        return ItemCastingRecipeBuilder.castingRecipe(result, (ItemCastingRecipe.Serializer)((Object)TinkerSmeltery.retexturedBasinRecipeSerializer.get()));
    }

    public static ItemCastingRecipeBuilder basinRecipe(ItemLike resultIn) {
        return ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromItem((ItemLike)resultIn));
    }

    public static ItemCastingRecipeBuilder basinRecipe(TagKey<Item> result) {
        return ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromTag(result, (int)1));
    }

    public static ItemCastingRecipeBuilder tableRecipe(ItemOutput resultIn) {
        return ItemCastingRecipeBuilder.castingRecipe(resultIn, (ItemCastingRecipe.Serializer)((Object)TinkerSmeltery.tableRecipeSerializer.get()));
    }

    public static ItemCastingRecipeBuilder retexturedTableRecipe(ItemOutput resultIn) {
        return ItemCastingRecipeBuilder.castingRecipe(resultIn, (ItemCastingRecipe.Serializer)((Object)TinkerSmeltery.retexturedTableRecipeSerializer.get()));
    }

    public static ItemCastingRecipeBuilder tableRecipe(ItemLike resultIn) {
        return ItemCastingRecipeBuilder.tableRecipe(ItemOutput.fromItem((ItemLike)resultIn));
    }

    public static ItemCastingRecipeBuilder tableRecipe(TagKey<Item> result) {
        return ItemCastingRecipeBuilder.tableRecipe(ItemOutput.fromTag(result, (int)1));
    }

    public ItemCastingRecipeBuilder setFluid(Fluid fluid, int amount) {
        return this.setFluid(FluidIngredient.of((Fluid)fluid, (int)amount));
    }

    public ItemCastingRecipeBuilder setFluid(TagKey<Fluid> tagIn, int amount) {
        return this.setFluid(FluidIngredient.of(tagIn, (int)amount));
    }

    public ItemCastingRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public ItemCastingRecipeBuilder setCoolingTime(int temperature, int amount) {
        return this.setCoolingTime(ICastingRecipe.calcCoolingTime(temperature, amount));
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidStack fluidStack) {
        this.fluid = FluidIngredient.of((FluidStack)fluidStack);
        if (this.coolingTime == -1) {
            this.coolingTime = ICastingRecipe.calcCoolingTime(fluidStack);
        }
        return this;
    }

    public ItemCastingRecipeBuilder setFluidAndTime(int temperature, TagKey<Fluid> tagIn, int amount) {
        this.setFluid(tagIn, amount);
        this.setCoolingTime(temperature, amount);
        return this;
    }

    public ItemCastingRecipeBuilder setFluidAndTime(Fluid fluid, TagKey<Fluid> tag, int amount) {
        return this.setFluidAndTime(fluid.getAttributes().getTemperature() - 300, tag, amount);
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidObject<?> fluid, boolean forgeTag, int amount) {
        return this.setFluidAndTime((Fluid)fluid.get(), (TagKey<Fluid>)(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag()), amount);
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidObject<?> fluid, int amount) {
        return this.setFluidAndTime(fluid, false, amount);
    }

    public ItemCastingRecipeBuilder setCast(TagKey<Item> tagIn, boolean consumed) {
        return this.setCast(Ingredient.m_204132_(tagIn), consumed);
    }

    public ItemCastingRecipeBuilder setCast(ItemLike itemIn, boolean consumed) {
        return this.setCast(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}), consumed);
    }

    public ItemCastingRecipeBuilder setCast(Ingredient ingredient, boolean consumed) {
        this.cast = ingredient;
        this.consumed = consumed;
        return this;
    }

    public ItemCastingRecipeBuilder setSwitchSlots() {
        this.switchSlots = true;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, Objects.requireNonNull(this.result.get().m_41720_().getRegistryName()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Casting recipes require a fluid input");
        }
        if (this.coolingTime < 0) {
            throw new IllegalStateException("Cooling time is too low, must be at least 0");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept((FinishedRecipe)new Result(id, advancementId));
    }

    private ItemCastingRecipeBuilder(ItemOutput result, ItemCastingRecipe.Serializer<?> recipeSerializer) {
        this.result = result;
        this.recipeSerializer = recipeSerializer;
    }

    public static ItemCastingRecipeBuilder castingRecipe(ItemOutput result, ItemCastingRecipe.Serializer<?> recipeSerializer) {
        return new ItemCastingRecipeBuilder(result, recipeSerializer);
    }

    public ItemCastingRecipeBuilder setCoolingTime(int coolingTime) {
        this.coolingTime = coolingTime;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)ItemCastingRecipeBuilder.this, ID, advancementID);
        }

        public RecipeSerializer<?> m_6637_() {
            return ItemCastingRecipeBuilder.this.recipeSerializer;
        }

        public void m_7917_(JsonObject json) {
            if (!ItemCastingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", ItemCastingRecipeBuilder.this.group);
            }
            if (ItemCastingRecipeBuilder.this.cast != Ingredient.f_43901_) {
                json.add("cast", ItemCastingRecipeBuilder.this.cast.m_43942_());
                if (ItemCastingRecipeBuilder.this.consumed) {
                    json.addProperty("cast_consumed", Boolean.valueOf(true));
                }
            }
            if (ItemCastingRecipeBuilder.this.switchSlots) {
                json.addProperty("switch_slots", Boolean.valueOf(true));
            }
            json.add("fluid", ItemCastingRecipeBuilder.this.fluid.serialize());
            json.add("result", ItemCastingRecipeBuilder.this.result.serialize());
            json.addProperty("cooling_time", (Number)ItemCastingRecipeBuilder.this.coolingTime);
        }
    }
}

