/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.RandomLevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageTakenModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public record MobEffectModule(IJsonPredicate<LivingEntity> target, MobEffect effect, RandomLevelingValue level, RandomLevelingValue time, ModifierModuleCondition condition) implements DamageTakenModifierHook,
MeleeHitModifierHook,
ProjectileLaunchModifierHook,
ProjectileHitModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.DAMAGE_TAKEN, TinkerHooks.MELEE_HIT, TinkerHooks.PROJECTILE_LAUNCH, TinkerHooks.PROJECTILE_HIT);
    public static final GenericLoaderRegistry.IGenericLoader<MobEffectModule> LOADER = new GenericLoaderRegistry.IGenericLoader<MobEffectModule>(){

        public MobEffectModule deserialize(JsonObject json) {
            return new MobEffectModule((IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.getAndDeserialize(json, "target")), (MobEffect)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (JsonObject)json, (String)"effect"), RandomLevelingValue.get(json, "level"), RandomLevelingValue.get(json, "time"), ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(MobEffectModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.add("target", LivingEntityPredicate.LOADER.serialize(object.target));
            json.addProperty("effect", Objects.requireNonNull(object.effect.getRegistryName()).toString());
            json.add("level", (JsonElement)object.level.serialize());
            json.add("time", (JsonElement)object.time.serialize());
        }

        public MobEffectModule fromNetwork(FriendlyByteBuf buffer) {
            return new MobEffectModule((IJsonPredicate<LivingEntity>)((IJsonPredicate)LivingEntityPredicate.LOADER.fromNetwork(buffer)), (MobEffect)buffer.readRegistryIdUnsafe(ForgeRegistries.MOB_EFFECTS), RandomLevelingValue.fromNetwork(buffer), RandomLevelingValue.fromNetwork(buffer), ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(MobEffectModule object, FriendlyByteBuf buffer) {
            LivingEntityPredicate.LOADER.toNetwork(object.target, buffer);
            buffer.writeRegistryIdUnsafe(ForgeRegistries.MOB_EFFECTS, (IForgeRegistryEntry)object.effect);
            object.level.toNetwork(buffer);
            object.time.toNetwork(buffer);
            object.condition.toNetwork(buffer);
        }
    };

    public static Builder builder(MobEffect effect) {
        return new Builder(effect);
    }

    private void applyEffect(@Nullable LivingEntity target, float scaledLevel) {
        if (target == null || !this.target.matches((Object)target)) {
            return;
        }
        int level = Math.round(this.level.computeValue(scaledLevel)) - 1;
        if (level < 0) {
            return;
        }
        float duration = this.time.computeValue(scaledLevel);
        if (duration > 0.0f) {
            target.m_7292_(new MobEffectInstance(this.effect, (int)duration, level));
        }
    }

    @Override
    public void onDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity attacker = source.m_7639_();
        if (isDirectDamage && attacker instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)attacker;
            float scaledLevel = modifier.getEffectiveLevel(tool);
            if (TConstruct.RANDOM.nextFloat() < scaledLevel * 0.25f) {
                this.applyEffect(living, scaledLevel);
                ToolDamageUtil.damageAnimated(tool, 1, context.getEntity(), slotType);
            }
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        this.applyEffect(context.getLivingTarget(), modifier.getEffectiveLevel(tool));
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        persistentData.putFloat(modifier.getId(), modifier.getEffectiveLevel(tool));
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        this.applyEffect(target, persistentData.getFloat(modifier.getId()));
        return false;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static class Builder
    extends ModifierModuleCondition.Builder<Builder> {
        private final MobEffect effect;
        private IJsonPredicate<LivingEntity> target = LivingEntityPredicate.ANY;
        private RandomLevelingValue level = RandomLevelingValue.flat(1.0f);
        private RandomLevelingValue time = RandomLevelingValue.flat(0.0f);

        public MobEffectModule build() {
            return new MobEffectModule(this.target, this.effect, this.level, this.time, this.condition);
        }

        private Builder(MobEffect effect) {
            this.effect = effect;
        }

        public Builder target(IJsonPredicate<LivingEntity> target) {
            this.target = target;
            return this;
        }

        public Builder level(RandomLevelingValue level) {
            this.level = level;
            return this;
        }

        public Builder time(RandomLevelingValue time) {
            this.time = time;
            return this;
        }
    }
}

