/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.FormulaModuleLoader;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public record ReduceToolDamageModule(ModifierFormula formula, ModifierModuleCondition condition) implements ModifierModule,
ToolDamageModifierHook,
TooltipModifierHook,
FormulaModuleLoader.FormulaModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.TOOL_DAMAGE, TinkerHooks.TOOLTIP);
    public static final FormulaModuleLoader<ReduceToolDamageModule> LOADER = new FormulaModuleLoader<ReduceToolDamageModule>(ReduceToolDamageModule::new, ModifierFormula.FallbackFormula.IDENTITY, "level");

    public static FormulaModuleLoader.Builder builder() {
        return LOADER.builder();
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private float getPercent(IToolContext tool, ModifierEntry modifier) {
        return this.formula.apply(this.formula.computeLevel(tool, modifier));
    }

    public static int reduceDamage(int amount, float percentage) {
        if (percentage >= 1.0f) {
            return 0;
        }
        if (percentage <= 0.0f) {
            return amount;
        }
        int dealt = 0;
        for (int i = 0; i < amount; ++i) {
            if (!(TConstruct.RANDOM.nextFloat() >= percentage)) continue;
            ++dealt;
        }
        return dealt;
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        if (this.condition.matches(tool, modifier)) {
            return ReduceToolDamageModule.reduceDamage(amount, this.getPercent(tool, modifier));
        }
        return amount;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (this.condition.matches(tool, modifier)) {
            tooltip.add((Component)modifier.getModifier().applyStyle(new TextComponent(Util.PERCENT_FORMAT.format(this.getPercent(tool, modifier)) + " ").m_7220_(modifier.getModifier().getDisplayName())));
        }
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }
}

