/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.AttributeModuleBuilder;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record AttributeModule(String unique, Attribute attribute, AttributeModifier.Operation operation, LevelingValue amount, UUID[] slotUUIDs, ModifierModuleCondition condition) implements AttributesModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.ATTRIBUTES);
    public static final GenericLoaderRegistry.IGenericLoader<AttributeModule> LOADER = new GenericLoaderRegistry.IGenericLoader<AttributeModule>(){
        private static final BiFunction<JsonElement, String, EquipmentSlot> SLOT_PARSER = (element, string) -> EquipmentSlot.m_20747_((String)GsonHelper.m_13805_((JsonElement)element, (String)string));

        public AttributeModule deserialize(JsonObject json) {
            String unique = GsonHelper.m_13906_((JsonObject)json, (String)"unique");
            return new AttributeModule(unique, (Attribute)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (JsonObject)json, (String)"attribute"), (AttributeModifier.Operation)JsonHelper.getAsEnum((JsonObject)json, (String)"operation", AttributeModifier.Operation.class), LevelingValue.deserialize(json), AttributeModule.slotsToUUIDs(unique, JsonHelper.parseList((JsonObject)json, (String)"slots", SLOT_PARSER)), ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(AttributeModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.addProperty("unique", object.unique);
            json.addProperty("attribute", Objects.requireNonNull(object.attribute.getRegistryName()).toString());
            json.addProperty("operation", object.operation.name().toLowerCase(Locale.ROOT));
            object.amount.serialize(json);
            JsonArray array = new JsonArray();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (object.slotUUIDs[slot.m_20750_()] == null) continue;
                array.add(slot.m_20751_());
            }
            json.add("slots", (JsonElement)array);
        }

        public AttributeModule fromNetwork(FriendlyByteBuf buffer) {
            String name = buffer.m_130136_(Short.MAX_VALUE);
            byte packed = buffer.readByte();
            UUID[] slotUUIDs = new UUID[6];
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if ((packed & 1 << slot.m_20750_()) <= 0) continue;
                slotUUIDs[slot.m_20750_()] = AttributeModule.getUUID(name, slot);
            }
            return new AttributeModule(name, (Attribute)buffer.readRegistryIdUnsafe(ForgeRegistries.ATTRIBUTES), (AttributeModifier.Operation)buffer.m_130066_(AttributeModifier.Operation.class), LevelingValue.fromNetwork(buffer), slotUUIDs, ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(AttributeModule object, FriendlyByteBuf buffer) {
            buffer.m_130070_(object.unique);
            int packed = 0;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (object.slotUUIDs[slot.m_20750_()] == null) continue;
                packed |= 1 << slot.m_20750_();
            }
            buffer.writeByte(packed);
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ATTRIBUTES, (IForgeRegistryEntry)object.attribute);
            buffer.m_130068_((Enum)object.operation);
            object.amount.toNetwork(buffer);
            object.condition.toNetwork(buffer);
        }
    };

    public static UUID getUUID(String name, EquipmentSlot slot) {
        return UUID.nameUUIDFromBytes((name + "." + slot.m_20751_()).getBytes());
    }

    public static UUID[] slotsToUUIDs(String name, Collection<EquipmentSlot> slots) {
        UUID[] slotUUIDs = new UUID[6];
        for (EquipmentSlot slot : slots) {
            slotUUIDs[slot.m_20750_()] = AttributeModule.getUUID(name, slot);
        }
        return slotUUIDs;
    }

    @Override
    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        UUID uuid;
        if (this.condition.matches(tool, modifier) && (uuid = this.slotUUIDs[slot.m_20750_()]) != null) {
            consumer.accept(this.attribute, new AttributeModifier(uuid, this.unique + "." + slot.m_20751_(), (double)this.amount.compute(tool, modifier), this.operation));
        }
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder(Attribute attribute, AttributeModifier.Operation operation) {
        return new Builder(attribute, operation);
    }

    public static class Builder
    extends AttributeModuleBuilder<Builder, AttributeModule> {
        private EquipmentSlot[] slots = EquipmentSlot.values();

        protected Builder(Attribute attribute, AttributeModifier.Operation operation) {
            super(attribute, operation);
        }

        public Builder slots(EquipmentSlot ... slots) {
            this.slots = slots;
            return this;
        }

        @Override
        public AttributeModule amount(float flat, float eachLevel) {
            if (this.unique == null) {
                throw new IllegalStateException("Must set unique for attributes");
            }
            return new AttributeModule(this.unique, this.attribute, this.operation, new LevelingValue(flat, eachLevel), AttributeModule.slotsToUUIDs(this.unique, List.of(this.slots)), this.condition);
        }
    }
}

