/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.modifiers.modules.armor.ArmorWalkRadiusModule;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public record ReplaceBlockWalkerModule(List<BlockReplacement> replacements, LevelingValue radius, IJsonPredicate<IToolContext> tool) implements ArmorWalkRadiusModule<Void>,
ModifierModule
{
    public static final GenericLoaderRegistry.IGenericLoader<ReplaceBlockWalkerModule> LOADER = new GenericLoaderRegistry.IGenericLoader<ReplaceBlockWalkerModule>(){
        private static final Function<JsonObject, BlockReplacement> REPLACEMENT_PARSER = BlockReplacement::deserialize;

        public ReplaceBlockWalkerModule deserialize(JsonObject json) {
            return new ReplaceBlockWalkerModule(JsonHelper.parseList((JsonObject)json, (String)"replace", REPLACEMENT_PARSER), LevelingValue.deserialize(GsonHelper.m_13930_((JsonObject)json, (String)"radius")), (IJsonPredicate<IToolContext>)((IJsonPredicate)ToolContextPredicate.LOADER.getAndDeserialize(json, "tool")));
        }

        public void serialize(ReplaceBlockWalkerModule object, JsonObject json) {
            if (object.tool != ToolContextPredicate.ANY) {
                json.add("tool", ToolContextPredicate.LOADER.serialize(object.tool));
            }
            JsonArray array = new JsonArray();
            for (BlockReplacement replacement : object.replacements) {
                array.add((JsonElement)replacement.serialize());
            }
            json.add("replace", (JsonElement)array);
            json.add("radius", (JsonElement)object.radius.serialize(new JsonObject()));
        }

        public ReplaceBlockWalkerModule fromNetwork(FriendlyByteBuf buffer) {
            int max = buffer.m_130242_();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < max; ++i) {
                builder.add((Object)BlockReplacement.fromNetwork(buffer));
            }
            return new ReplaceBlockWalkerModule((List<BlockReplacement>)builder.build(), LevelingValue.fromNetwork(buffer), (IJsonPredicate<IToolContext>)((IJsonPredicate)ToolContextPredicate.LOADER.fromNetwork(buffer)));
        }

        public void toNetwork(ReplaceBlockWalkerModule object, FriendlyByteBuf buffer) {
            buffer.m_130130_(object.replacements.size());
            for (BlockReplacement replacement : object.replacements) {
                replacement.toNetwork(buffer);
            }
            object.radius.toNetwork(buffer);
            ToolContextPredicate.LOADER.toNetwork(object.tool, buffer);
        }
    };

    @Override
    public float getRadius(IToolStackView tool, ModifierEntry modifier) {
        return this.radius.compute(modifier.getLevel() + tool.getModifierLevel(TinkerModifiers.expanded.getId()));
    }

    @Override
    public void onWalk(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (this.tool.matches((Object)tool)) {
            ArmorWalkRadiusModule.super.onWalk(tool, modifier, living, prevPos, newPos);
        }
    }

    @Override
    public void walkOn(IToolStackView tool, ModifierEntry entry, LivingEntity living, Level world, BlockPos target, BlockPos.MutableBlockPos mutable, Void context) {
        if (world.m_46859_(target)) {
            mutable.m_122178_(target.m_123341_(), target.m_123342_() - 1, target.m_123343_());
            int level = entry.getLevel();
            for (BlockReplacement replacement : this.replacements) {
                if (!replacement.level.test(level)) continue;
                BlockState state = replacement.state;
                if (!replacement.target.matches((Object)world.m_8055_((BlockPos)mutable)) || !state.m_60710_((LevelReader)world, (BlockPos)mutable) || !world.m_45752_(state, (BlockPos)mutable, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)living, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)mutable), (Direction)Direction.UP)) continue;
                world.m_46597_((BlockPos)mutable, state);
                world.m_186460_((BlockPos)mutable, state.m_60734_(), Mth.m_14072_((Random)living.m_21187_(), (int)60, (int)120));
                break;
            }
        }
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder builder() {
        return new Builder();
    }

    private record BlockReplacement(IJsonPredicate<BlockState> target, BlockState state, IntRange level) {
        public static BlockReplacement deserialize(JsonObject json) {
            return new BlockReplacement((IJsonPredicate<BlockState>)((IJsonPredicate)BlockPredicate.LOADER.getAndDeserialize(json, "target")), JsonHelper.convertToBlockState((JsonObject)json), ModifierModuleCondition.MODIFIER_LEVEL.getAndDeserialize(json, "modifier_level"));
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.add("target", BlockPredicate.LOADER.serialize(this.target));
            JsonHelper.serializeBlockState((BlockState)this.state, (JsonObject)json);
            ModifierModuleCondition.MODIFIER_LEVEL.serializeInto(json, "modifier_level", this.level);
            return json;
        }

        public static BlockReplacement fromNetwork(FriendlyByteBuf buffer) {
            return new BlockReplacement((IJsonPredicate<BlockState>)((IJsonPredicate)BlockPredicate.LOADER.fromNetwork(buffer)), Block.m_49803_((int)buffer.m_130242_()), IntRange.fromNetwork(buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer) {
            BlockPredicate.LOADER.toNetwork(this.target, buffer);
            buffer.m_130130_(Block.m_49956_((BlockState)this.state));
            this.level.toNetwork(buffer);
        }
    }

    public static class Builder
    implements LevelingValue.Builder<ReplaceBlockWalkerModule> {
        private final ImmutableList.Builder<BlockReplacement> replacements = ImmutableList.builder();
        private IJsonPredicate<IToolContext> tool = ToolContextPredicate.ANY;

        private Builder() {
        }

        private Builder replaceLevelRange(IJsonPredicate<BlockState> target, BlockState replacement, IntRange modifierLevel) {
            this.replacements.add((Object)new BlockReplacement(target, replacement, modifierLevel));
            return this;
        }

        public Builder replaceLevelRange(IJsonPredicate<BlockState> target, BlockState replacement, int min, int max) {
            return this.replaceLevelRange(target, replacement, ModifierModuleCondition.MODIFIER_LEVEL.range(min, max));
        }

        public Builder replaceMinLevel(IJsonPredicate<BlockState> target, BlockState replacement, int max) {
            return this.replaceLevelRange(target, replacement, ModifierModuleCondition.MODIFIER_LEVEL.max(max));
        }

        public Builder replaceMaxLevel(IJsonPredicate<BlockState> target, BlockState replacement, int min) {
            return this.replaceLevelRange(target, replacement, ModifierModuleCondition.MODIFIER_LEVEL.min(min));
        }

        public Builder replaceAlways(IJsonPredicate<BlockState> target, BlockState replacement) {
            return this.replaceLevelRange(target, replacement, ModifierModuleCondition.MODIFIER_LEVEL);
        }

        @Override
        public ReplaceBlockWalkerModule amount(float flat, float eachLevel) {
            ImmutableList replacements = this.replacements.build();
            if (replacements.isEmpty()) {
                throw new IllegalStateException("Must have at least 1 replacement");
            }
            return new ReplaceBlockWalkerModule((List<BlockReplacement>)replacements, new LevelingValue(flat, eachLevel), this.tool);
        }

        public Builder tool(IJsonPredicate<IToolContext> tool) {
            this.tool = tool;
            return this;
        }
    }
}

