/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record BlockDamageSourceModule(IJsonPredicate<DamageSource> source, ModifierModuleCondition condition) implements DamageBlockModifierHook,
ModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.DAMAGE_BLOCK);
    public static final GenericLoaderRegistry.IGenericLoader<BlockDamageSourceModule> LOADER = new GenericLoaderRegistry.IGenericLoader<BlockDamageSourceModule>(){

        public BlockDamageSourceModule deserialize(JsonObject json) {
            return new BlockDamageSourceModule((IJsonPredicate<DamageSource>)((IJsonPredicate)DamageSourcePredicate.LOADER.getAndDeserialize(json, "damage_source")), ModifierModuleCondition.deserializeFrom(json));
        }

        public void serialize(BlockDamageSourceModule object, JsonObject json) {
            object.condition.serializeInto(json);
            json.add("damage_source", DamageSourcePredicate.LOADER.serialize(object.source));
        }

        public BlockDamageSourceModule fromNetwork(FriendlyByteBuf buffer) {
            return new BlockDamageSourceModule((IJsonPredicate<DamageSource>)((IJsonPredicate)DamageSourcePredicate.LOADER.fromNetwork(buffer)), ModifierModuleCondition.fromNetwork(buffer));
        }

        public void toNetwork(BlockDamageSourceModule object, FriendlyByteBuf buffer) {
            DamageSourcePredicate.LOADER.toNetwork(object.source, buffer);
            object.condition.toNetwork(buffer);
        }
    };

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public boolean isDamageBlocked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount) {
        return this.condition.matches(tool, modifier) && this.source.matches((Object)source);
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static Builder source(IJsonPredicate<DamageSource> source) {
        return new Builder(source);
    }

    public static class Builder
    extends ModifierModuleCondition.Builder<Builder> {
        private final IJsonPredicate<DamageSource> source;

        public BlockDamageSourceModule build() {
            return new BlockDamageSourceModule(this.source, this.condition);
        }

        private Builder(IJsonPredicate<DamageSource> source) {
            this.source = source;
        }
    }
}

