/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.predicate.tool.ItemToolPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;

public record ModifierModuleCondition(IJsonPredicate<IToolContext> tool, IntRange modifierLevel) {
    public static final IntRange MODIFIER_LEVEL = new IntRange(1, Short.MAX_VALUE);
    public static final ModifierModuleCondition ANY = new ModifierModuleCondition(ToolContextPredicate.ANY, MODIFIER_LEVEL);

    public ModifierModuleCondition with(IJsonPredicate<IToolContext> tool) {
        return new ModifierModuleCondition(tool, this.modifierLevel);
    }

    public ModifierModuleCondition with(IntRange modifierLevel) {
        return new ModifierModuleCondition(this.tool, modifierLevel);
    }

    public boolean matches(IToolContext tool, ModifierEntry modifier) {
        return this.modifierLevel.test(modifier.getLevel()) && this.tool.matches((Object)tool);
    }

    public void serializeInto(JsonObject parent) {
        if (this.tool != ToolContextPredicate.ANY) {
            parent.add("tool", ToolContextPredicate.LOADER.serialize(this.tool));
        }
        MODIFIER_LEVEL.serializeInto(parent, "modifier_level", this.modifierLevel);
    }

    public static ModifierModuleCondition deserializeFrom(JsonObject parent) {
        IJsonPredicate tool = (IJsonPredicate)ToolContextPredicate.LOADER.getAndDeserialize(parent, "tool");
        IntRange modifierLevel = MODIFIER_LEVEL.getAndDeserialize(parent, "modifier_level");
        return new ModifierModuleCondition((IJsonPredicate<IToolContext>)tool, modifierLevel);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        ToolContextPredicate.LOADER.toNetwork(this.tool, buffer);
        this.modifierLevel.toNetwork(buffer);
    }

    public static ModifierModuleCondition fromNetwork(FriendlyByteBuf buffer) {
        IJsonPredicate tool = (IJsonPredicate)ToolContextPredicate.LOADER.fromNetwork(buffer);
        IntRange modifierLevel = IntRange.fromNetwork(buffer);
        return new ModifierModuleCondition((IJsonPredicate<IToolContext>)tool, modifierLevel);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected ModifierModuleCondition condition = ANY;

        private T setCondition(ModifierModuleCondition condition) {
            this.condition = condition;
            return (T)this;
        }

        public T tool(IJsonPredicate<IToolContext> tool) {
            return this.setCondition(this.condition.with(tool));
        }

        public T toolItem(IJsonPredicate<Item> tool) {
            return this.tool(new ItemToolPredicate(tool));
        }

        private T setLevels(IntRange range) {
            return this.setCondition(this.condition.with(range));
        }

        public T levelRange(int min, int max) {
            return this.setLevels(MODIFIER_LEVEL.range(min, max));
        }

        public T minLevel(int min) {
            return this.setLevels(MODIFIER_LEVEL.min(min));
        }

        public T maxLevel(int max) {
            return this.setLevels(MODIFIER_LEVEL.max(max));
        }

        public T exactLevel(int value) {
            return this.setLevels(MODIFIER_LEVEL.exactly(value));
        }
    }

    public record Loader<T extends GenericLoaderRegistry.IHaveLoader<?>>(Function<ModifierModuleCondition, T> constructor, Function<T, ModifierModuleCondition> getter) implements GenericLoaderRegistry.IGenericLoader<T>
    {
        public T deserialize(JsonObject json) {
            return (T)((GenericLoaderRegistry.IHaveLoader)this.constructor.apply(ModifierModuleCondition.deserializeFrom(json)));
        }

        public void serialize(T object, JsonObject json) {
            this.getter.apply(object).serializeInto(json);
        }

        public T fromNetwork(FriendlyByteBuf buffer) {
            return (T)((GenericLoaderRegistry.IHaveLoader)this.constructor.apply(ModifierModuleCondition.fromNetwork(buffer)));
        }

        public void toNetwork(T object, FriendlyByteBuf buffer) {
            this.getter.apply(object).toNetwork(buffer);
        }
    }
}

