/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.library.utils.TooltipKey;

@Deprecated
public class ConditionalDamageModifier
extends IncrementalModifier {
    private final IJsonPredicate<LivingEntity> predicate;
    private final float damageBonus;
    @Nullable
    private final MobEffect effect;
    private final int effectLevel;
    public static final GenericLoaderRegistry.IGenericLoader<ConditionalDamageModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<ConditionalDamageModifier>(){

        public ConditionalDamageModifier deserialize(JsonObject json) {
            IJsonPredicate predicate = (IJsonPredicate)LivingEntityPredicate.LOADER.getAndDeserialize(json, "entity");
            float damage = GsonHelper.m_13915_((JsonObject)json, (String)"damage");
            MobEffect effect = null;
            int level = 0;
            if (json.has("effect")) {
                JsonObject effectJson = GsonHelper.m_13930_((JsonObject)json, (String)"effect");
                effect = (MobEffect)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (JsonObject)effectJson, (String)"name");
                level = JsonUtils.getIntMin(effectJson, "level", 1);
            }
            return new ConditionalDamageModifier(predicate, damage, effect, level);
        }

        public void serialize(ConditionalDamageModifier object, JsonObject json) {
            json.add("entity", LivingEntityPredicate.LOADER.serialize(object.predicate));
            json.addProperty("damage", (Number)Float.valueOf(object.damageBonus));
            if (object.effect != null && object.effectLevel > 0) {
                JsonObject effectJson = new JsonObject();
                effectJson.addProperty("name", Objects.requireNonNull(object.effect.getRegistryName()).toString());
                effectJson.addProperty("level", (Number)object.effectLevel);
                json.add("effect", (JsonElement)effectJson);
            }
        }

        public ConditionalDamageModifier fromNetwork(FriendlyByteBuf buffer) {
            IJsonPredicate predicate = (IJsonPredicate)LivingEntityPredicate.LOADER.fromNetwork(buffer);
            float damage = buffer.readFloat();
            MobEffect effect = null;
            int level = buffer.m_130242_();
            if (level > 0) {
                effect = (MobEffect)buffer.readRegistryIdUnsafe(ForgeRegistries.MOB_EFFECTS);
            }
            return new ConditionalDamageModifier(predicate, damage, effect, level);
        }

        public void toNetwork(ConditionalDamageModifier object, FriendlyByteBuf buffer) {
            LivingEntityPredicate.LOADER.toNetwork(object.predicate, buffer);
            buffer.writeFloat(object.damageBonus);
            if (object.effectLevel > 0 && object.effect != null) {
                buffer.m_130130_(object.effectLevel);
                buffer.writeRegistryIdUnsafe(ForgeRegistries.MOB_EFFECTS, (IForgeRegistryEntry)object.effect);
            } else {
                buffer.m_130130_(0);
            }
        }
    };

    public ConditionalDamageModifier(IJsonPredicate<LivingEntity> predicate, float damageBonus) {
        this(predicate, damageBonus, null, 0);
    }

    @Override
    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity target = context.getLivingTarget();
        if (target != null && this.predicate.matches(target)) {
            damage += this.getScaledLevel(tool, level) * this.damageBonus * tool.getMultiplier(ToolStats.ATTACK_DAMAGE);
        }
        return damage;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        this.addDamageTooltip(tool, level, this.damageBonus, tooltip);
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        LivingEntity target;
        if (this.effect != null && (target = context.getLivingTarget()) != null && this.predicate.matches(target)) {
            int duration = 20;
            int maxBonus = (int)(10.0f * this.getScaledLevel(tool, level));
            if (maxBonus > 0) {
                duration += context.getAttacker().m_21187_().nextInt(maxBonus);
            }
            target.m_7292_(new MobEffectInstance(this.effect, duration, this.effectLevel - 1));
        }
        return 0;
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    public ConditionalDamageModifier(IJsonPredicate<LivingEntity> predicate, float damageBonus, @Nullable MobEffect effect, int effectLevel) {
        this.predicate = predicate;
        this.damageBonus = damageBonus;
        this.effect = effect;
        this.effectLevel = effectLevel;
    }
}

