/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.utils.IdParser;

public final class MaterialId
extends ResourceLocation
implements MaterialVariantId {
    public static final IdParser<MaterialId> PARSER = new IdParser<MaterialId>(MaterialId::new, "Material");

    public MaterialId(String resourceName) {
        super(resourceName);
    }

    public MaterialId(String namespaceIn, String pathIn) {
        super(namespaceIn, pathIn);
    }

    public MaterialId(ResourceLocation resourceLocation) {
        super(resourceLocation.m_135827_(), resourceLocation.m_135815_());
    }

    public boolean matches(IMaterial material) {
        return this.equals(material.getIdentifier());
    }

    public boolean matches(ItemStack stack) {
        return !stack.m_41619_() && this.equals(IMaterialItem.getMaterialFromStack(stack));
    }

    @Override
    public MaterialId getId() {
        return this;
    }

    @Override
    public String getVariant() {
        return "";
    }

    @Override
    public boolean hasVariant() {
        return false;
    }

    @Override
    public ResourceLocation getLocation(char separator) {
        return this;
    }

    @Override
    public boolean matchesVariant(MaterialVariantId other) {
        return this.equals(other.getId());
    }

    @Nullable
    public static MaterialId tryParse(String string) {
        return PARSER.tryParse(string);
    }

    public static MaterialId fromJson(JsonObject json, String key) {
        return PARSER.getFromJson(json, key);
    }

    public static MaterialId convertJson(JsonElement json, String key) {
        return PARSER.convertFromJson(json, key);
    }
}

