/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.entity;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.variable.ConditionalVariableLoader;
import slimeknights.tconstruct.library.json.variable.entity.EntityVariable;

public final class ConditionalEntityVariable
extends Record
implements EntityVariable,
ConditionalVariableLoader.ConditionalVariable<IJsonPredicate<LivingEntity>, EntityVariable> {
    private final IJsonPredicate<LivingEntity> condition;
    private final EntityVariable ifTrue;
    private final EntityVariable ifFalse;
    public static final GenericLoaderRegistry.IGenericLoader<ConditionalEntityVariable> LOADER = new ConditionalVariableLoader<ConditionalEntityVariable, IJsonPredicate, EntityVariable>(LivingEntityPredicate.LOADER, EntityVariable.LOADER, ConditionalEntityVariable::new);

    public ConditionalEntityVariable(IJsonPredicate<LivingEntity> condition, float ifTrue, float ifFalse) {
        this(condition, new EntityVariable.Constant(ifTrue), new EntityVariable.Constant(ifFalse));
    }

    public ConditionalEntityVariable(IJsonPredicate<LivingEntity> condition, EntityVariable ifTrue, EntityVariable ifFalse) {
        this.condition = condition;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    @Override
    public float getValue(LivingEntity entity) {
        return this.condition.matches((Object)entity) ? this.ifTrue.getValue(entity) : this.ifFalse.getValue(entity);
    }

    public GenericLoaderRegistry.IGenericLoader<? extends EntityVariable> getLoader() {
        return LOADER;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ConditionalEntityVariable.class, "condition;ifTrue;ifFalse", "condition", "ifTrue", "ifFalse"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ConditionalEntityVariable.class, "condition;ifTrue;ifFalse", "condition", "ifTrue", "ifFalse"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ConditionalEntityVariable.class, "condition;ifTrue;ifFalse", "condition", "ifTrue", "ifFalse"}, this, o);
    }

    @Override
    public IJsonPredicate<LivingEntity> condition() {
        return this.condition;
    }

    @Override
    public EntityVariable ifTrue() {
        return this.ifTrue;
    }

    @Override
    public EntityVariable ifFalse() {
        return this.ifFalse;
    }
}

