/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.tool;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record StatInSetPredicate<T>(IToolStat<T> stat, Set<T> values) implements ToolContextPredicate
{
    public static final GenericLoaderRegistry.IGenericLoader<StatInSetPredicate<?>> LOADER = new GenericLoaderRegistry.IGenericLoader<StatInSetPredicate<?>>(){

        public StatInSetPredicate<?> deserialize(JsonObject json) {
            return 1.deserialize(json, ToolStats.fromJson(GsonHelper.m_13906_((JsonObject)json, (String)"stat")));
        }

        private static <T> StatInSetPredicate<T> deserialize(JsonObject json, IToolStat<T> stat) {
            ImmutableSet values = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"values", (element, key) -> stat.deserialize((JsonElement)element)));
            return new StatInSetPredicate<T>(stat, values);
        }

        public void serialize(StatInSetPredicate<?> object, JsonObject json) {
            json.addProperty("stat", object.stat.getName().toString());
            1.serializeSet(object, json);
        }

        private static <T> void serializeSet(StatInSetPredicate<T> object, JsonObject json) {
            JsonArray array = new JsonArray();
            for (Object value : object.values) {
                array.add(object.stat.serialize(value));
            }
            json.add("values", (JsonElement)array);
        }

        public StatInSetPredicate<?> fromNetwork(FriendlyByteBuf buffer) {
            return 1.fromNetwork(buffer, ToolStats.fromNetwork(buffer));
        }

        private static <T> StatInSetPredicate<T> fromNetwork(FriendlyByteBuf buffer, IToolStat<T> stat) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            int max = buffer.m_130242_();
            for (int i = 0; i < max; ++i) {
                builder.add(stat.fromNetwork(buffer));
            }
            return new StatInSetPredicate<T>(stat, builder.build());
        }

        public void toNetwork(StatInSetPredicate<?> object, FriendlyByteBuf buffer) {
            buffer.m_130070_(object.stat.toString());
            1.setToNetwork(object, buffer);
        }

        private static <T> void setToNetwork(StatInSetPredicate<T> object, FriendlyByteBuf buffer) {
            buffer.m_130130_(object.values.size());
            for (Object value : object.values) {
                object.stat.toNetwork(buffer, value);
            }
        }
    };

    public StatInSetPredicate(IToolStat<T> stat, T value) {
        this(stat, Set.of(value));
    }

    public boolean matches(IToolContext tool) {
        return this.values.contains(tool.getStats().get(this.stat));
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IJsonPredicate<IToolContext>> getLoader() {
        return LOADER;
    }
}

