/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.primitive;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.array.FloatArrayLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public record FloatLoadable(float min, float max) implements Loadable<Float>
{
    public static final FloatLoadable ANY = FloatLoadable.range(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
    public static final FloatLoadable FROM_ZERO = FloatLoadable.min(0.0f);
    public static final FloatLoadable PERCENT = FloatLoadable.range(0.0f, 1.0f);

    public static FloatLoadable range(float min, float max) {
        return new FloatLoadable(min, max);
    }

    public static FloatLoadable min(float min) {
        return new FloatLoadable(min, Float.POSITIVE_INFINITY);
    }

    private float validate(float value, String key) {
        if (this.min <= value && value <= this.max) {
            return value;
        }
        if (this.min == Float.NEGATIVE_INFINITY) {
            throw new JsonSyntaxException(key + " must not be greater than " + this.max);
        }
        if (this.max == Float.POSITIVE_INFINITY) {
            throw new JsonSyntaxException(key + " must not be less than " + this.min);
        }
        throw new JsonSyntaxException(key + " must be between " + this.min + " and " + this.max);
    }

    @Override
    public Float convert(JsonElement element, String key, TypedMap context) {
        return Float.valueOf(this.validate(GsonHelper.m_13888_((JsonElement)element, (String)key), key));
    }

    @Override
    public Float decode(FriendlyByteBuf buffer, TypedMap context) {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    public JsonElement serialize(Float object) {
        return new JsonPrimitive((Number)Float.valueOf(this.validate(object.floatValue(), "Value")));
    }

    @Override
    public void encode(FriendlyByteBuf buffer, Float object) {
        buffer.writeFloat(object.floatValue());
    }

    public ArrayLoadable<float[]> array(int minSize, int maxSize) {
        return new FloatArrayLoadable(this, minSize, maxSize);
    }

    public ArrayLoadable<float[]> array(int minSize) {
        return this.array(minSize, Integer.MAX_VALUE);
    }
}

