/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectFunction;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.field.DefaultingField;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.util.typed.TypedMap;

public record ByteArrayLoadable<T extends Number>(Loadable<T> base, int minSize, int maxSize, Byte2ObjectFunction<T> mapper) implements ArrayLoadable.SizeRange<byte[]>
{
    @Override
    public int getLength(byte[] array) {
        return array.length;
    }

    @Override
    public byte[] convertCompact(JsonElement element, String key, TypedMap context) {
        return new byte[]{((Number)this.base.convert(element, key, context)).byteValue()};
    }

    @Override
    public byte[] convertArray(JsonArray array, String key, TypedMap context) {
        byte[] result = new byte[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Number)this.base.convert(array.get(i), key + "[" + i + "]", context)).byteValue();
        }
        return result;
    }

    @Override
    public JsonElement serializeFirst(byte[] object) {
        return this.base.serialize((Number)this.mapper.get(object[0]));
    }

    @Override
    public void serializeAll(JsonArray array, byte[] object) {
        for (byte element : object) {
            array.add(this.base.serialize((Number)this.mapper.get(element)));
        }
    }

    @Override
    public byte[] decode(FriendlyByteBuf buffer, TypedMap context) {
        int max = buffer.m_130242_();
        byte[] array = new byte[max];
        for (int i = 0; i < max; ++i) {
            array[i] = ((Number)this.base.decode(buffer, context)).byteValue();
        }
        return array;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, byte[] array) {
        buffer.m_130130_(array.length);
        for (byte element : array) {
            this.base.encode(buffer, (Number)this.mapper.get(element));
        }
    }

    @Override
    public <P> LoadableField<byte[], P> defaultField(String key, byte[] defaultValue, boolean serializeDefault, Function<P, byte[]> getter) {
        return new DefaultingField<byte[], P>(this, key, defaultValue, serializeDefault ? null : Arrays::equals, getter);
    }

    @Override
    public <P> LoadableField<byte[], P> emptyField(String key, boolean serializeEmpty, Function<P, byte[]> getter) {
        return this.defaultField(key, new byte[0], serializeEmpty, getter);
    }
}

