/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.recipe.condition.TagFilledCondition;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;
import slimeknights.mantle.registration.object.IdAwareObject;

public interface IRecipeHelper {
    public String getModId();

    default public ResourceLocation location(String name) {
        return new ResourceLocation(this.getModId(), name);
    }

    default public String prefix(String id) {
        return this.getModId() + ":" + id;
    }

    default public ResourceLocation id(ItemLike item) {
        return this.id((Registry)BuiltInRegistries.f_257033_, (Object)item.m_5456_());
    }

    default public <T> ResourceLocation id(Registry<T> registry, T value) {
        return this.location(Objects.requireNonNull(registry.m_7981_(value)).m_135815_());
    }

    default public ResourceLocation wrap(ResourceLocation location, String prefix, String suffix) {
        return this.location(prefix + location.m_135815_() + suffix);
    }

    default public ResourceLocation prefix(ResourceLocation location, String prefix) {
        return this.location(prefix + location.m_135815_());
    }

    default public ResourceLocation suffix(ResourceLocation location, String suffix) {
        return this.location(location.m_135815_() + suffix);
    }

    default public ResourceLocation wrap(RegistryObject<?> location, String prefix, String suffix) {
        return this.wrap(location.getId(), prefix, suffix);
    }

    default public ResourceLocation prefix(RegistryObject<?> location, String prefix) {
        return this.prefix(location.getId(), prefix);
    }

    default public ResourceLocation suffix(RegistryObject<?> location, String suffix) {
        return this.suffix(location.getId(), suffix);
    }

    default public ResourceLocation wrap(IdAwareObject location, String prefix, String suffix) {
        return this.wrap(location.getId(), prefix, suffix);
    }

    default public ResourceLocation prefix(IdAwareObject location, String prefix) {
        return this.prefix(location.getId(), prefix);
    }

    default public ResourceLocation suffix(IdAwareObject location, String suffix) {
        return this.suffix(location.getId(), suffix);
    }

    default public TagKey<Item> getItemTag(String modId, String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(modId, name));
    }

    default public TagKey<Fluid> getFluidTag(String modId, String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)new ResourceLocation(modId, name));
    }

    default public ICondition tagCondition(String name) {
        return new TagFilledCondition(ItemTags.create((ResourceLocation)Mantle.commonResource(name)));
    }

    default public Consumer<FinishedRecipe> withCondition(Consumer<FinishedRecipe> consumer, ICondition ... conditions) {
        ConsumerWrapperBuilder builder = ConsumerWrapperBuilder.wrap();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder.build(consumer);
    }
}

