/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.function.ToIntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.math.NumberUtils;
import slimeknights.mantle.Mantle;

public class TextureColorHelper {
    private static final Object2IntMap<ResourceLocation> SPRITE_CACHE = new Object2IntOpenHashMap();
    private static final Object2IntMap<Item> ITEM_CACHE = new Object2IntOpenHashMap();
    private static final Object2IntMap<Block> BLOCK_CACHE = new Object2IntOpenHashMap();
    public static final ResourceManagerReloadListener RELOAD_LISTENER = manager -> {
        SPRITE_CACHE.clear();
        ITEM_CACHE.clear();
        BLOCK_CACHE.clear();
    };
    private static final ToIntFunction<ResourceLocation> COMPUTE_SPRITE_COLOR = key -> {
        Minecraft mc = Minecraft.m_91087_();
        TextureAtlasSprite sprite = mc.m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(key);
        if (sprite == null || sprite.m_245424_().m_246162_() == MissingTextureAtlasSprite.m_118071_()) {
            return -1;
        }
        return TextureColorHelper.getAverageColor(sprite);
    };
    private static final ToIntFunction<Item> COMPUTE_ITEM_COLOR = item -> {
        Minecraft mc = Minecraft.m_91087_();
        BakedModel model = mc.m_91291_().m_174264_(new ItemStack((ItemLike)item), null, null, 0);
        if (model == mc.m_91304_().m_119409_()) {
            return -1;
        }
        return TextureColorHelper.getAverageColor(model.getParticleIcon(ModelData.EMPTY));
    };
    private static final ToIntFunction<Block> COMPUTE_BLOCK_COLOR = block -> {
        Minecraft mc = Minecraft.m_91087_();
        BakedModel model = mc.m_91289_().m_110910_(block.m_49966_());
        if (model == mc.m_91304_().m_119409_()) {
            return -1;
        }
        return TextureColorHelper.getAverageColor(model.getParticleIcon(ModelData.EMPTY));
    };

    private TextureColorHelper() {
    }

    private static int computeAverageColor(TextureAtlasSprite sprite) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float count = 0.0f;
        float[] hsb = new float[3];
        try {
            SpriteContents contents = sprite.m_245424_();
            for (int x = 0; x < contents.m_246492_(); ++x) {
                for (int y = 0; y < contents.m_245330_(); ++y) {
                    int argb = sprite.getPixelRGBA(0, x, y);
                    int cr = argb & 0xFF;
                    int cg = argb >> 8 & 0xFF;
                    int cb = argb >> 16 & 0xFF;
                    int ca = argb >> 24 & 0xFF;
                    if (ca <= 127 || NumberUtils.max((int)cr, (int)cg, (int)cb) <= 31) continue;
                    Color.RGBtoHSB(ca, cr, cg, hsb);
                    float weight = hsb[1];
                    r += (float)cr * weight;
                    g += (float)cg * weight;
                    b += (float)cb * weight;
                    count += weight;
                }
            }
        }
        catch (Exception e) {
            Mantle.logger.error("Caught exception reading sprite for {}", (Object)sprite.m_245424_().m_246162_(), (Object)e);
            return -1;
        }
        if (count > 0.0f) {
            r /= count;
            g /= count;
            b /= count;
        }
        return 0xFF000000 | (int)r << 16 | (int)g << 8 | (int)b;
    }

    public static int getAverageColor(ResourceLocation texture) {
        return SPRITE_CACHE.computeIfAbsent((Object)texture, COMPUTE_SPRITE_COLOR);
    }

    public static int getAverageColor(TextureAtlasSprite sprite) {
        ResourceLocation name = sprite.m_245424_().m_246162_();
        if (SPRITE_CACHE.containsKey((Object)name)) {
            return SPRITE_CACHE.get((Object)name);
        }
        int color = TextureColorHelper.computeAverageColor(sprite);
        SPRITE_CACHE.put((Object)name, color);
        return color;
    }

    public static int getItemColor(ItemLike item) {
        return ITEM_CACHE.computeIfAbsent((Object)item.m_5456_(), COMPUTE_ITEM_COLOR);
    }

    public static int getBlockColor(Block block) {
        return BLOCK_CACHE.computeIfAbsent((Object)block, COMPUTE_BLOCK_COLOR);
    }
}

