/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableIngredientSerializer;
import slimeknights.mantle.recipe.ingredient.ItemIngredient;

public class PotionIngredient
extends ItemIngredient {
    public static final LoadableIngredientSerializer<PotionIngredient> SERIALIZER = new LoadableIngredientSerializer<PotionIngredient>(RecordLoadable.create(ItemIngredient.ItemsField.INSTANCE, TAG_FIELD, Loadables.POTION.defaultField("potion", Potions.f_43598_, false, i -> i.potion), PotionIngredient::new));
    private final Potion potion;

    protected PotionIngredient(List<Item> items, @Nullable TagKey<Item> itemTag, Potion potion) {
        super(items, itemTag, Stream.concat(items.stream().map(item -> new Ingredient.ItemValue(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)potion))), Stream.ofNullable(itemTag).map(tag -> new PotionTagValue((TagKey<Item>)tag, potion))));
        this.potion = potion;
    }

    public static PotionIngredient of(Potion potion, List<ItemLike> items) {
        return new PotionIngredient(PotionIngredient.toItem(items), null, potion);
    }

    public static PotionIngredient of(Potion potion, ItemLike ... items) {
        return PotionIngredient.of(potion, Arrays.asList(items));
    }

    public static PotionIngredient of(Potion potion, TagKey<Item> tag) {
        return new PotionIngredient(List.of(), tag, potion);
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        return stack != null && super.test(stack) && PotionUtils.m_43579_((ItemStack)stack) == this.potion;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement m_43942_() {
        return SERIALIZER.serialize(this);
    }

    private static class PotionTagValue
    extends Ingredient.TagValue {
        private final Potion potion;

        public PotionTagValue(TagKey<Item> tag, Potion potion) {
            super(tag);
            this.potion = potion;
        }

        public Collection<ItemStack> m_6223_() {
            return super.m_6223_().stream().map(item -> PotionUtils.m_43549_((ItemStack)item, (Potion)this.potion)).toList();
        }
    }
}

