/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.network;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.network.packet.ISimplePacket;

public class NetworkWrapper {
    public final SimpleChannel network;
    private int id = 0;

    @Deprecated
    public NetworkWrapper(ResourceLocation channelName) {
        this(channelName, "1");
    }

    public NetworkWrapper(ResourceLocation channelName, String version) {
        this.network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).clientAcceptedVersions(version::equals).serverAcceptedVersions(version::equals).networkProtocolVersion(() -> version).simpleChannel();
    }

    public <MSG extends ISimplePacket> void registerPacket(Class<MSG> clazz, Function<FriendlyByteBuf, MSG> decoder, @Nullable NetworkDirection direction) {
        this.registerPacket(clazz, ISimplePacket::encode, decoder, ISimplePacket::handle, direction);
    }

    public <MSG> void registerPacket(Class<MSG> clazz, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer, @Nullable NetworkDirection direction) {
        this.registerPacketNoLogger(clazz, encoder, NetworkWrapper.wrapLogger(clazz, decoder), consumer, direction);
    }

    public <MSG> void registerPacketNoLogger(Class<MSG> clazz, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer, @Nullable NetworkDirection direction) {
        this.network.registerMessage(this.id++, clazz, encoder, decoder, consumer, Optional.ofNullable(direction));
    }

    private static <MSG> Function<FriendlyByteBuf, MSG> wrapLogger(Class<MSG> clazz, Function<FriendlyByteBuf, MSG> decoder) {
        return buffer -> {
            try {
                return decoder.apply((FriendlyByteBuf)buffer);
            }
            catch (Exception e) {
                Mantle.logger.error("Exception while decoding packet of class {}", (Object)clazz.getName(), (Object)e);
                throw e;
            }
        };
    }

    public void sendToServer(Object msg) {
        this.network.sendToServer(msg);
    }

    public void send(PacketDistributor.PacketTarget target, Object message) {
        this.network.send(target, message);
    }

    public void sendVanillaPacket(Packet<?> packet, Entity player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            sPlayer.f_8906_.m_9829_(packet);
        }
    }

    public void sendTo(Object msg, Player player) {
        if (player instanceof ServerPlayer) {
            this.sendTo(msg, (ServerPlayer)player);
        }
    }

    public void sendTo(Object msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            this.network.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void sendToClientsAround(Object msg, ServerLevel serverWorld, BlockPos position) {
        LevelChunk chunk = serverWorld.m_46745_(position);
        this.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), msg);
    }

    public void sendToTrackingAndSelf(Object msg, Entity entity) {
        this.network.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), msg);
    }

    public void sendToTracking(Object msg, Entity entity) {
        this.network.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), msg);
    }
}

