/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.registry.AbstractNamedComponentRegistry;
import slimeknights.mantle.registration.object.IdAwareObject;

public class IdAwareComponentRegistry<T extends IdAwareObject>
extends AbstractNamedComponentRegistry<T> {
    private final Map<ResourceLocation, T> values = new HashMap<ResourceLocation, T>();

    public IdAwareComponentRegistry(String errorText) {
        super(errorText);
    }

    public synchronized <V extends T> V register(V value) {
        ResourceLocation name = value.getId();
        if (this.values.putIfAbsent(name, value) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return value;
    }

    @Override
    @Nullable
    public T getValue(ResourceLocation name) {
        return (T)((IdAwareObject)this.values.get(name));
    }

    @Override
    public ResourceLocation getKey(T object) {
        return object.getId();
    }

    @Override
    public Collection<ResourceLocation> getKeys() {
        return this.values.keySet();
    }

    @Override
    public Collection<T> getValues() {
        return this.values.values();
    }
}

