/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.mapping;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.mapping.SetLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.util.typed.TypedMap;

public class EnumSetLoadable<T extends Enum<T>>
extends SetLoadable<T> {
    private final Class<T> enumClass;

    public EnumSetLoadable(Class<T> enumClass, Loadable<T> base, int minSize) {
        super(base, minSize);
        this.enumClass = enumClass;
    }

    public EnumSetLoadable(EnumLoadable<T> base, int minSize) {
        this(base.enumClass(), base, minSize);
    }

    @Override
    protected Collection<T> createBuilder(int size) {
        return EnumSet.noneOf(this.enumClass);
    }

    @Override
    protected Set<T> build(Collection<T> builder) {
        return Collections.unmodifiableSet((Set)builder);
    }

    @Override
    public Set<T> convertCompact(JsonElement element, String key, TypedMap context) {
        return this.build(EnumSet.of((Enum)this.base.convert(element, key, context)));
    }
}

