/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.AbstractIngredient;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.field.UnsyncedField;
import slimeknights.mantle.util.typed.TypedMap;

public abstract class ItemIngredient
extends AbstractIngredient {
    protected static final LoadableField<TagKey<Item>, ItemIngredient> TAG_FIELD = new UnsyncedField<TagKey, ItemIngredient>(Loadables.ITEM_TAG.nullableField("tag", i -> i.tag));
    protected final List<Item> items;
    @Nullable
    protected final TagKey<Item> tag;

    protected ItemIngredient(List<Item> items, @Nullable TagKey<Item> tag, Stream<? extends Ingredient.Value> values) {
        super(values);
        this.items = items;
        this.tag = tag;
    }

    protected ItemIngredient(List<Item> items, @Nullable TagKey<Item> tag) {
        this(items, tag, Stream.concat(items.stream().map(item -> new Ingredient.ItemValue(new ItemStack((ItemLike)item))), Stream.ofNullable(tag).map(Ingredient.TagValue::new)));
    }

    protected static List<Item> toItem(List<ItemLike> items) {
        return items.stream().map(ItemLike::m_5456_).toList();
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && (this.items.contains(stack.m_41720_()) || this.tag != null && stack.m_204117_(this.tag));
    }

    public static enum ItemsField implements RecordField<List<Item>, ItemIngredient>
    {
        INSTANCE;

        private static final Loadable<List<Item>> ITEM_LIST;

        @Override
        public List<Item> get(JsonObject json, TypedMap context) {
            return ITEM_LIST.getOrDefault(json, "item", List.of(), context);
        }

        @Override
        public void serialize(ItemIngredient parent, JsonObject json) {
            if (!parent.items.isEmpty()) {
                json.add("item", ITEM_LIST.serialize(parent.items));
            }
        }

        @Override
        public List<Item> decode(FriendlyByteBuf buffer, TypedMap context) {
            return (List)ITEM_LIST.decode(buffer, context);
        }

        @Override
        public void encode(FriendlyByteBuf buffer, ItemIngredient parent) {
            ITEM_LIST.encode(buffer, Arrays.stream(parent.m_43908_()).map(ItemStack::m_41720_).toList());
        }

        static {
            ITEM_LIST = Loadables.ITEM.list(-2);
        }
    }
}

