/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.ContentPadding;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.PageIconLinkElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class ContentPageIconList
extends PageContent {
    protected final int width;
    protected final int height;
    public String title;
    public String subText;
    public float maxScale = 2.5f;
    protected List<PageIconLinkElement> elements = Lists.newArrayList();

    public ContentPageIconList() {
        this(20);
    }

    public ContentPageIconList(int size) {
        this(size, size);
    }

    public ContentPageIconList(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean addLink(SizedBookElement element, Component name, PageData pageData) {
        if (this.elements.size() >= this.getMaxIconCount()) {
            return false;
        }
        this.elements.add(new PageIconLinkElement(0, 0, element, name, pageData));
        return true;
    }

    public int getMaxIconCount() {
        return this.getMaxColumns() * this.getMaxRows();
    }

    public int getMaxRows() {
        int totalHeight = 176;
        if (this.title != null) {
            totalHeight -= this.getTitleHeight();
        }
        if (this.subText != null) {
            totalHeight -= 16 + this.parent.parent.parent.fontRenderer.m_92920_(this.subText, 182) * 12 / 9;
        }
        return totalHeight / this.height;
    }

    public int getMaxColumns() {
        return 152 / this.width;
    }

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int offset;
        int yOff = 0;
        if (this.title != null) {
            this.addTitle(list, this.title, false);
            yOff = this.getTitleHeight();
        }
        if (this.subText != null) {
            int height = this.addText(list, this.subText, false, 0, yOff);
            yOff = height + 16;
        }
        int x = offset = 15;
        int y = yOff;
        int pageW = 182 - 2 * offset;
        int pageH = 176 - yOff;
        float scale = this.maxScale;
        int scaledWidth = this.width;
        int scaledHeight = this.height;
        boolean fits = false;
        while (!fits && scale > 1.0f) {
            int cols;
            scaledWidth = (int)((float)this.width * (scale -= 0.25f));
            int rows = pageW / scaledWidth;
            fits = rows * (cols = pageH / (scaledHeight = (int)((float)this.height * scale))) >= this.elements.size();
        }
        for (PageIconLinkElement element : this.elements) {
            element.x = x;
            element.y = y;
            element.displayElement.x = x + (int)(scale * (float)(this.width - element.displayElement.width) / 2.0f);
            element.displayElement.y = y + (int)(scale * (float)(this.height - element.displayElement.height) / 2.0f);
            element.width = scaledWidth;
            element.height = scaledHeight;
            element.displayElement.scale(scale);
            list.add(element);
            if ((x += scaledWidth) <= 182 - offset - scaledWidth) continue;
            x = offset;
            if ((y += scaledHeight) <= 176 - scaledHeight) continue;
            break;
        }
    }

    public static List<ContentPageIconList> getPagesNeededForItemCount(int count, SectionData data, String title, String subText) {
        ArrayList<ContentPageIconList> listPages = new ArrayList<ContentPageIconList>();
        ArrayList<PageData> newPages = new ArrayList<PageData>();
        while (count > 0) {
            ContentPageIconList overview = new ContentPageIconList();
            PageData page2 = new PageData(true);
            page2.source = data.source;
            page2.parent = data;
            page2.content = overview;
            page2.load();
            newPages.add(page2);
            overview.title = title;
            overview.subText = subText;
            listPages.add(overview);
            count -= overview.getMaxIconCount();
        }
        if (listPages.size() > 1) {
            listPages.forEach(page -> {
                page.maxScale = 1.0f;
            });
        }
        if (listPages.size() % 2 == 0) {
            PageData padding = new PageData(true);
            padding.source = data.source;
            padding.parent = data;
            padding.content = new ContentPadding.ContentRightPadding();
            padding.load();
            int sectionIndex = data.parent.sections.indexOf(data);
            if (sectionIndex > 0) {
                data.parent.sections.get((int)(sectionIndex - 1)).pages.add(padding);
            } else {
                newPages.add(0, padding);
            }
        }
        data.pages.addAll(0, newPages);
        return listPages;
    }

    public static void addPages(SectionData data, List<ContentPageIconList> indexList, Collection<PageWithIcon> pages, int index) {
        Iterator<ContentPageIconList> indexes = indexList.iterator();
        ContentPageIconList overview = indexes.next();
        ArrayList<PageData> newPages = new ArrayList<PageData>(pages.size());
        for (PageWithIcon page : pages) {
            newPages.add(page.page);
            while (!overview.addLink(page.icon, (Component)Component.m_237113_((String)page.page.getTitle()), page.page)) {
                overview = indexes.next();
            }
        }
        if (index == -1) {
            data.pages.addAll(newPages);
        } else {
            data.pages.addAll(index, newPages);
        }
    }

    public static void addPages(SectionData data, List<ContentPageIconList> indexList, Collection<PageWithIcon> pages) {
        ContentPageIconList.addPages(data, indexList, pages, indexList.size());
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public record PageWithIcon(SizedBookElement icon, PageData page) {
    }
}

