/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.datagen;

import javax.annotation.Nullable;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.fluid.transfer.AbstractFluidContainerTransferProvider;
import slimeknights.mantle.fluid.transfer.EmptyPotionTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.recipe.condition.TagFilledCondition;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;

@ApiStatus.Internal
public class MantleFluidTransferProvider
extends AbstractFluidContainerTransferProvider {
    public MantleFluidTransferProvider(PackOutput packOutput) {
        super(packOutput, "mantle");
    }

    public String m_6055_() {
        return "Mantle fluid transfer provider";
    }

    @Override
    protected void addTransfers() {
        this.addTransfer("wet_sponge", (IFluidContainerTransfer)new FillFluidContainerTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41902_}), ItemOutput.fromItem((ItemLike)Items.f_41903_), FluidIngredient.of(MantleTags.Fluids.WATER, 250)), new ICondition[0]);
        this.addPotion("potion/", (ItemLike)Items.f_42589_, null);
        this.addPotion("potion/splash/", (ItemLike)Items.f_42736_, MantleTags.Items.SPLASH_BOTTLE);
        this.addPotion("potion/lingering/", (ItemLike)Items.f_42739_, MantleTags.Items.LINGERING_BOTTLE);
        this.optionalFillEmpty("honey_bottle_", (ItemLike)Items.f_42787_, (ItemLike)Items.f_42590_, MantleTags.Fluids.HONEY, 250, false);
        this.optionalFillEmpty("beetroot_soup_", (ItemLike)Items.f_42734_, (ItemLike)Items.f_42399_, MantleTags.Fluids.BEETROOT_SOUP, 250, false);
        this.optionalFillEmpty("mushroom_stew_", (ItemLike)Items.f_42400_, (ItemLike)Items.f_42399_, MantleTags.Fluids.MUSHROOM_STEW, 250, false);
        this.optionalFillEmpty("rabbit_stew_", (ItemLike)Items.f_42699_, (ItemLike)Items.f_42399_, MantleTags.Fluids.RABBIT_STEW, 250, false);
    }

    private void optionalFillEmpty(String prefix, ItemLike item, ItemLike container, TagKey<Fluid> tag, int amount, boolean nbt) {
        this.addFillEmpty(prefix, item, container, tag, amount, nbt, new TagFilledCondition<Fluid>(tag));
    }

    protected void addPotion(String prefix, ItemLike filled, @Nullable TagKey<Item> bottleTag) {
        ICondition[] potionConditions;
        ICondition[] waterConditions;
        Ingredient container;
        TagFilledCondition<Fluid> potionCondition = new TagFilledCondition<Fluid>(MantleTags.Fluids.POTION);
        if (bottleTag != null) {
            container = Ingredient.m_204132_(bottleTag);
            TagFilledCondition<Item> containerCondition = new TagFilledCondition<Item>(bottleTag);
            waterConditions = new ICondition[]{containerCondition};
            potionConditions = new ICondition[]{potionCondition, containerCondition};
            this.addTransfer(prefix + "empty_glass_bottle", (IFluidContainerTransfer)new EmptyPotionTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{filled}), ItemOutput.fromItem((ItemLike)Items.f_42590_), 250), new ICondition[]{new NotCondition(containerCondition)});
            this.addTransfer(prefix + "empty_unique_bottle", (IFluidContainerTransfer)new EmptyPotionTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{filled}), ItemOutput.fromTag(bottleTag), 250), containerCondition);
        } else {
            container = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_});
            waterConditions = new ICondition[]{};
            potionConditions = new ICondition[]{potionCondition};
            this.addTransfer(prefix + "empty", (IFluidContainerTransfer)new EmptyPotionTransfer(Ingredient.m_43929_((ItemLike[])new ItemLike[]{filled}), ItemOutput.fromItem((ItemLike)Items.f_42590_), 250), new ICondition[0]);
        }
        this.addTransfer(prefix + "fill_potion", (IFluidContainerTransfer)new FillFluidWithNBTTransfer(container, ItemOutput.fromItem(filled), FluidIngredient.of(MantleTags.Fluids.POTION, 250)), potionConditions);
        this.addTransfer(prefix + "fill_water", (IFluidContainerTransfer)new FillFluidContainerTransfer(container, ItemOutput.fromStack(PotionUtils.m_43549_((ItemStack)new ItemStack(filled), (Potion)Potions.f_43599_)), FluidIngredient.of(MantleTags.Fluids.WATER, 500)), waterConditions);
    }
}

