/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.block.GaugeBlock;
import slimeknights.mantle.client.ExtraHeartRenderHandler;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.repository.FileRepository;
import slimeknights.mantle.client.model.FallbackModelLoader;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.TextureColorHelper;
import slimeknights.mantle.client.model.connected.ConnectedModel;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.render.FluidCuboid;
import slimeknights.mantle.client.render.RenderItem;
import slimeknights.mantle.command.client.MantleClientCommand;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.fluid.texture.FluidTextureManager;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.mantle.registration.MantleRegistrations;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.util.OffhandCooldownTracker;
import slimeknights.mantle.util.RegistryHelper;

@Mod.EventBusSubscriber(modid="mantle", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    public static void onConstruct() {
    }

    @SubscribeEvent
    static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (MantleRegistrations.SIGN != null) {
            event.registerBlockEntityRenderer(MantleRegistrations.SIGN, SignRenderer::new);
        }
        if (MantleRegistrations.HANGING_SIGN != null) {
            event.registerBlockEntityRenderer(MantleRegistrations.HANGING_SIGN, HangingSignRenderer::new);
        }
    }

    @SubscribeEvent
    static void registerListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ModelHelper.LISTENER);
        event.registerReloadListener((PreparableReloadListener)new BookLoader());
        ResourceColorManager.init(event);
        FluidTooltipHandler.init(event);
        FluidTextureManager.init(event);
        event.registerReloadListener(FluidCuboid.REGISTRY);
        event.registerReloadListener(RenderItem.REGISTRY);
        event.registerReloadListener(RenderItem.STATE_REGISTRY);
        event.registerReloadListener((PreparableReloadListener)TextureColorHelper.RELOAD_LISTENER);
    }

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> RegistrationHelper.forEachWoodType(Sheets::addWoodType));
        BookLoader.registerBook(Mantle.getResource("test"), new FileRepository(Mantle.getResource("books/test")));
        MantleClientCommand.init();
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("connected", ConnectedModel.LOADER);
        event.register("item_layer", MantleItemLayerModel.LOADER);
        event.register("colored_block", ColoredBlockModel.LOADER);
        event.register("fallback", (IGeometryLoader)FallbackModelLoader.INSTANCE);
        event.register("nbt_key", NBTKeyModel.LOADER);
        event.register("retextured", RetexturedModel.LOADER);
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ExtraHeartRenderHandler());
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderGuiOverlayEvent.Post.class, ClientEvents::renderOffhandAttackIndicator);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderGuiOverlayEvent.Post.class, ClientEvents::renderGaugeTooltip);
    }

    private static void renderOffhandAttackIndicator(RenderGuiOverlayEvent.Post event) {
        boolean isHotbar;
        Minecraft minecraft = Minecraft.m_91087_();
        Options settings = minecraft.f_91066_;
        AttackIndicatorStatus indicator = (AttackIndicatorStatus)settings.m_232120_().m_231551_();
        if (minecraft.f_91074_ == null || minecraft.f_91072_ == null || minecraft.f_91072_.m_105295_() == GameType.SPECTATOR || indicator == AttackIndicatorStatus.OFF) {
            return;
        }
        NamedGuiOverlay overlay = event.getOverlay();
        boolean bl = isHotbar = VanillaGuiOverlay.HOTBAR.type() == overlay;
        if (!isHotbar && VanillaGuiOverlay.CROSSHAIR.type() != overlay) {
            return;
        }
        OffhandCooldownTracker tracker = OffhandCooldownTracker.get((Player)minecraft.f_91074_);
        if (tracker == null) {
            return;
        }
        float cooldown = tracker.getCooldown();
        if (cooldown >= 1.0f) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        switch (indicator) {
            case CROSSHAIR: {
                if (isHotbar || !minecraft.f_91066_.m_92176_().m_90612_() || settings.f_92063_ && !settings.f_92062_ && !minecraft.f_91074_.m_36330_() && !((Boolean)settings.m_231824_().m_231551_()).booleanValue()) break;
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int scaledHeight = minecraft.m_91268_().m_85446_();
                int y = scaledHeight / 2 - 14 + 2 * (scaledHeight % 2);
                int x = minecraft.m_91268_().m_85445_() / 2 - 8;
                int width = (int)(cooldown * 17.0f);
                graphics.m_280218_(Gui.f_279580_, x, y, 36, 94, 16, 4);
                graphics.m_280218_(Gui.f_279580_, x, y, 52, 94, width, 4);
                break;
            }
            case HOTBAR: {
                if (!isHotbar || minecraft.f_91075_ != minecraft.f_91074_) break;
                int centerWidth = minecraft.m_91268_().m_85445_() / 2;
                int y = minecraft.m_91268_().m_85446_() - 20;
                int x = minecraft.f_91074_.m_5737_() == HumanoidArm.RIGHT ? centerWidth - 91 - 22 - 32 : centerWidth + 91 + 6 + 32;
                int l1 = (int)(cooldown * 19.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.m_280218_(Gui.f_279580_, x, y, 0, 94, 18, 18);
                graphics.m_280218_(Gui.f_279580_, x, y + 18 - l1, 18, 112 - l1, 18, l1);
            }
        }
    }

    private static void renderGaugeTooltip(RenderGuiOverlayEvent.Post event) {
        List<MutableComponent> tooltip;
        BlockEntity gaugeContainer;
        Direction side;
        if (event.getOverlay() != VanillaGuiOverlay.CROSSHAIR.type()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ != null && minecraft.f_91080_.getClass() != ChatScreen.class) {
            return;
        }
        if (minecraft.f_91073_ == null || minecraft.f_91077_ == null || minecraft.f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)minecraft.f_91077_;
        BlockPos pos = blockHit.m_82425_();
        BlockState targeted = minecraft.f_91073_.m_8055_(blockHit.m_82425_());
        if (!targeted.m_204336_(MantleTags.Blocks.GAUGES)) {
            return;
        }
        if (targeted.m_204336_(MantleTags.Blocks.ATTACHED_GAUGES)) {
            side = (Direction)targeted.m_61143_((Property)BlockStateProperties.f_61372_);
            gaugeContainer = minecraft.f_91073_.m_7702_(pos.m_121945_(side.m_122424_()));
        } else {
            side = blockHit.m_82434_();
            gaugeContainer = minecraft.f_91073_.m_7702_(pos);
        }
        if (gaugeContainer == null || RegistryHelper.contains(BuiltInRegistries.f_257049_, MantleTags.BlockEntities.GAUGE_BLACKLIST, gaugeContainer.m_58903_())) {
            return;
        }
        IFluidHandler handler = (IFluidHandler)gaugeContainer.getCapability(ForgeCapabilities.FLUID_HANDLER, side).orElse((Object)EmptyFluidHandler.INSTANCE);
        if (handler.getTanks() <= 0) {
            return;
        }
        FluidStack fluid = handler.getFluidInTank(0);
        if (fluid.isEmpty()) {
            tooltip = List.of(GaugeBlock.formatCapacity(handler.getTankCapacity(0)));
        } else if (RegistryHelper.contains(BuiltInRegistries.f_257049_, MantleTags.BlockEntities.HIDES_GAUGE_AMOUNT, gaugeContainer.m_58903_())) {
            ResourceLocation id = BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid());
            tooltip = new ArrayList<MutableComponent>(3);
            tooltip.add((MutableComponent)fluid.getDisplayName());
            FluidTooltipHandler.appendAdvanced(id, tooltip);
            tooltip.add(GaugeBlock.formatCapacity(handler.getTankCapacity(0)).m_130940_(ChatFormatting.GRAY));
            tooltip.add((MutableComponent)FluidTooltipHandler.formatModName(id));
        } else {
            tooltip = FluidTooltipHandler.getFluidTooltip(fluid);
        }
        int x = minecraft.m_91268_().m_85445_() / 2;
        int y = minecraft.m_91268_().m_85446_() / 2;
        event.getGuiGraphics().m_280677_(minecraft.f_91062_, tooltip, Optional.empty(), x, y);
    }
}

