/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.registry.DirectRegistryField;
import slimeknights.mantle.data.registry.MergingRegistryField;
import slimeknights.mantle.data.registry.NamedComponentRegistry;

public class GenericLoaderRegistry<T extends IHaveLoader>
implements Loadable<T> {
    protected static final JsonObject EMPTY_OBJECT = new JsonObject();
    private final String name;
    protected final NamedComponentRegistry<IGenericLoader<? extends T>> loaders;
    protected final boolean compact;

    public GenericLoaderRegistry(String name, boolean compact) {
        this.name = name;
        this.compact = compact;
        this.loaders = new NamedComponentRegistry("Unknown " + name + " loader");
    }

    public void register(ResourceLocation name, IGenericLoader<? extends T> loader) {
        this.loaders.register(name, loader);
    }

    @Override
    public T convert(JsonElement element, String key) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            return (T)((IHaveLoader)((IGenericLoader)this.loaders.getIfPresent(object, "type")).deserialize(object));
        }
        if (this.compact && element.isJsonPrimitive()) {
            EMPTY_OBJECT.entrySet().clear();
            return (T)((IHaveLoader)((IGenericLoader)this.loaders.convert(element, "type")).deserialize(EMPTY_OBJECT));
        }
        throw new JsonSyntaxException("Invalid " + this.name + " JSON at " + key + ", must be a JSON object" + (this.compact ? " or a string" : ""));
    }

    public T deserialize(JsonElement element) {
        return (T)this.convert(element, "[unknown]");
    }

    private <L extends IHaveLoader> JsonElement serialize(IGenericLoader<L> loader, T src) {
        JsonObject json = new JsonObject();
        JsonPrimitive type = new JsonPrimitive(this.loaders.getKey(loader).toString());
        json.add("type", (JsonElement)type);
        loader.serialize(src, json);
        if (json.get("type") != type) {
            throw new IllegalStateException(this.name + " serializer " + type.getAsString() + " modified the type key, this is not allowed as it breaks deserialization");
        }
        if (this.compact && json.entrySet().size() == 1) {
            return type;
        }
        return json;
    }

    @Override
    public JsonElement serialize(T src) {
        return this.serialize(src.getLoader(), src);
    }

    protected <L extends IHaveLoader> void toNetwork(IGenericLoader<L> loader, T src, FriendlyByteBuf buffer) {
        loader.toNetwork(src, buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T src) {
        this.loaders.encode(buffer, src.getLoader());
        this.toNetwork(src.getLoader(), src, buffer);
    }

    @Override
    public T decode(FriendlyByteBuf buffer) {
        return (T)((IHaveLoader)((IGenericLoader)this.loaders.decode(buffer)).fromNetwork(buffer));
    }

    public <P> LoadableField<T, P> directField(Function<P, T> getter) {
        return new DirectRegistryField<T, P>(this, getter);
    }

    public <P> LoadableField<T, P> directField(String typeKey, Function<P, T> getter) {
        return new MergingRegistryField<T, P>(this, typeKey, getter);
    }

    public String toString() {
        return this.getClass().getName() + "('" + this.name + "')";
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public static interface IGenericLoader<T> {
        public T deserialize(JsonObject var1);

        public T fromNetwork(FriendlyByteBuf var1);

        public void serialize(T var1, JsonObject var2);

        public void toNetwork(T var1, FriendlyByteBuf var2);
    }

    public static interface IHaveLoader {
        public IGenericLoader<? extends IHaveLoader> getLoader();
    }

    public static class SingletonLoader<T>
    implements IGenericLoader<T> {
        private final T instance;

        public SingletonLoader(Function<IGenericLoader<T>, T> creator) {
            this.instance = creator.apply(this);
        }

        @Override
        public T deserialize(JsonObject json) {
            return this.instance;
        }

        @Override
        public T fromNetwork(FriendlyByteBuf buffer) {
            return this.instance;
        }

        @Override
        public void serialize(T object, JsonObject json) {
        }

        @Override
        public void toNetwork(T object, FriendlyByteBuf buffer) {
        }

        public static <T> T singleton(Function<IGenericLoader<T>, T> instance) {
            return (T)new SingletonLoader<Function<IGenericLoader<T>, T>>(instance).getInstance();
        }

        public SingletonLoader(T instance) {
            this.instance = instance;
        }

        public T getInstance() {
            return this.instance;
        }
    }
}

