/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.crafting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.recipe.MantleRecipes;
import slimeknights.mantle.util.JsonHelper;

public class ShapedFallbackRecipe
extends ShapedRecipe {
    private final List<ResourceLocation> alternatives;
    private List<CraftingRecipe> alternativeCache;

    public ShapedFallbackRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, ItemStack output, List<ResourceLocation> alternatives) {
        super(id, group, category, width, height, ingredients, output);
        this.alternatives = alternatives;
    }

    public ShapedFallbackRecipe(ShapedRecipe base, List<ResourceLocation> alternatives) {
        super(base.m_6423_(), base.m_6076_(), base.m_245232_(), base.m_44220_(), base.m_44221_(), base.m_7527_(), base.f_44149_, base.m_271738_());
        this.alternatives = alternatives;
    }

    public boolean m_5818_(CraftingContainer inv, Level world) {
        if (!super.m_5818_(inv, world)) {
            return false;
        }
        if (this.alternativeCache == null) {
            RecipeManager manager = world.m_7465_();
            this.alternativeCache = this.alternatives.stream().map(arg_0 -> ((RecipeManager)manager).m_44043_(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(recipe -> {
                Class<?> clazz = recipe.getClass();
                return clazz == ShapedRecipe.class || clazz == ShapelessRecipe.class;
            }).map(recipe -> (CraftingRecipe)recipe).collect(Collectors.toList());
        }
        return this.alternativeCache.stream().noneMatch(recipe -> recipe.m_5818_((Container)inv, world));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MantleRecipes.CRAFTING_SHAPED_FALLBACK.get();
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public ShapedFallbackRecipe fromJson(ResourceLocation id, JsonObject json) {
            ShapedRecipe base = super.m_6729_(id, json);
            List<ResourceLocation> alternatives = JsonHelper.parseList(json, "alternatives", Loadables.RESOURCE_LOCATION);
            return new ShapedFallbackRecipe(base, alternatives);
        }

        public ShapedFallbackRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ShapedRecipe base = super.m_8005_(id, buffer);
            int size = buffer.m_130242_();
            ArrayList<ResourceLocation> builder = new ArrayList<ResourceLocation>(size);
            for (int i = 0; i < size; ++i) {
                builder.add(buffer.m_130281_());
            }
            return new ShapedFallbackRecipe(base, List.copyOf(builder));
        }

        public void m_6178_(FriendlyByteBuf buffer, ShapedRecipe recipe) {
            super.m_6178_(buffer, recipe);
            assert (recipe instanceof ShapedFallbackRecipe);
            List<ResourceLocation> alternatives = ((ShapedFallbackRecipe)recipe).alternatives;
            buffer.m_130130_(alternatives.size());
            for (ResourceLocation alternative : alternatives) {
                buffer.m_130085_(alternative);
            }
        }
    }
}

