/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class InvertedFluid
extends ForgeFlowingFluid {
    protected InvertedFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public Vec3 m_7000_(BlockGetter level, BlockPos pos, FluidState fluid) {
        double xHeight = 0.0;
        double zHeight = 0.0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.m_122159_((Vec3i)pos, direction);
            FluidState sideFluid = level.m_6425_((BlockPos)mutable);
            if (!this.m_76094_(sideFluid)) continue;
            float sideHeight = sideFluid.m_76182_();
            float deltaHeight = 0.0f;
            if (sideHeight == 0.0f) {
                BlockPos above;
                FluidState aboveFluid;
                if (!level.m_8055_((BlockPos)mutable).m_280555_() && this.m_76094_(aboveFluid = level.m_6425_(above = mutable.m_7494_())) && (sideHeight = aboveFluid.m_76182_()) > 0.0f) {
                    deltaHeight = fluid.m_76182_() - sideHeight + 0.8888889f;
                }
            } else if (sideHeight > 0.0f) {
                deltaHeight = fluid.m_76182_() - sideHeight;
            }
            if (deltaHeight == 0.0f) continue;
            xHeight += (double)((float)direction.m_122429_() * deltaHeight);
            zHeight += (double)((float)direction.m_122431_() * deltaHeight);
        }
        Vec3 vector = new Vec3(xHeight, 0.0, zHeight);
        if (((Boolean)fluid.m_61143_((Property)f_75947_)).booleanValue()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                mutable.m_122159_((Vec3i)pos, direction);
                if (!this.m_75990_(level, (BlockPos)mutable, direction) && !this.m_75990_(level, mutable.m_7495_(), direction)) continue;
                vector = vector.m_82541_().m_82520_(0.0, 6.0, 0.0);
                break;
            }
        }
        return vector.m_82541_();
    }

    protected boolean m_75990_(BlockGetter level, BlockPos neighbor, Direction side) {
        BlockState block = level.m_8055_(neighbor);
        FluidState fluid = level.m_6425_(neighbor);
        return !fluid.m_76152_().m_6212_((Fluid)this) && (side == Direction.DOWN || !(block.m_60734_() instanceof IceBlock) && block.m_60783_(level, neighbor, side));
    }

    protected void m_76010_(Level level, BlockPos pos, FluidState fluid) {
        if (!fluid.m_76178_()) {
            BlockState block = level.m_8055_(pos);
            BlockPos above = pos.m_7494_();
            BlockState aboveBlock = level.m_8055_(above);
            FluidState aboveFluid = this.m_76035_(level, above, aboveBlock);
            if (this.m_75977_((BlockGetter)level, pos, block, Direction.UP, above, aboveBlock, level.m_6425_(above), aboveFluid.m_76152_())) {
                this.m_6364_((LevelAccessor)level, above, aboveBlock, Direction.UP, aboveFluid);
                if (this.m_76019_((LevelReader)level, pos) >= 3) {
                    this.m_76014_(level, pos, fluid, block);
                }
            } else if (fluid.m_76170_() || !this.m_75956_((BlockGetter)level, aboveFluid.m_76152_(), pos, block, above, aboveBlock)) {
                this.m_76014_(level, pos, fluid, block);
            }
        }
    }

    protected FluidState m_76035_(Level level, BlockPos pos, BlockState block) {
        BlockPos below;
        BlockState belowBlock;
        FluidState belowFluid;
        int maxSide = 0;
        int sourceSides = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos side = pos.m_121945_(direction);
            BlockState sideBlock = level.m_8055_(side);
            FluidState sideFluid = sideBlock.m_60819_();
            if (!sideFluid.m_76152_().m_6212_((Fluid)this) || !this.m_76061_(direction, (BlockGetter)level, pos, block, side, sideBlock)) continue;
            if (sideFluid.m_76170_() && ForgeEventFactory.canCreateFluidSource((Level)level, (BlockPos)side, (BlockState)sideBlock, (boolean)sideFluid.canConvertToSource(level, side))) {
                ++sourceSides;
            }
            maxSide = Math.max(maxSide, sideFluid.m_76186_());
        }
        if (sourceSides >= 2) {
            BlockState aboveBlock = level.m_8055_(pos.m_7494_());
            FluidState aboveFluid = aboveBlock.m_60819_();
            if (aboveBlock.m_280296_() || this.m_76096_(aboveFluid)) {
                return this.m_76068_(false);
            }
        }
        if (!(belowFluid = (belowBlock = level.m_8055_(below = pos.m_7495_())).m_60819_()).m_76178_() && belowFluid.m_76152_().m_6212_((Fluid)this) && this.m_76061_(Direction.DOWN, (BlockGetter)level, pos, block, below, belowBlock)) {
            return this.m_75953_(8, true);
        }
        int newHeight = maxSide - this.m_6713_((LevelReader)level);
        return newHeight <= 0 ? Fluids.f_76191_.m_76145_() : this.m_75953_(newHeight, false);
    }

    protected int m_76026_(LevelReader level, BlockPos spreadPos, int distance, Direction direction, BlockState spreadBlock, BlockPos sourcePos, Short2ObjectMap<Pair<BlockState, FluidState>> stateCache, Short2BooleanMap waterHoleCache) {
        int minSlope = 1000;
        for (Direction horizontal : Direction.Plane.HORIZONTAL) {
            int slopeDistance;
            if (horizontal == direction) continue;
            BlockPos side = spreadPos.m_121945_(horizontal);
            short key = InvertedFluid.m_76058_((BlockPos)sourcePos, (BlockPos)side);
            Pair state = (Pair)stateCache.computeIfAbsent(key, p_284932_ -> {
                BlockState sideBlock = level.m_8055_(side);
                return Pair.of((Object)sideBlock, (Object)sideBlock.m_60819_());
            });
            BlockState sideBlock = (BlockState)state.getFirst();
            FluidState sideFluid = (FluidState)state.getSecond();
            if (!this.m_75963_((BlockGetter)level, this.m_5615_(), spreadPos, spreadBlock, horizontal, side, sideBlock, sideFluid)) continue;
            boolean isWaterHole = waterHoleCache.computeIfAbsent(key, k -> {
                BlockPos above = side.m_7494_();
                BlockState aboveState = level.m_8055_(above);
                return this.m_75956_((BlockGetter)level, this.m_5615_(), side, sideBlock, above, aboveState);
            });
            if (isWaterHole) {
                return distance;
            }
            if (distance >= this.m_6719_(level) || (slopeDistance = this.m_76026_(level, side, distance + 1, horizontal.m_122424_(), sideBlock, sourcePos, stateCache, waterHoleCache)) >= minSlope) continue;
            minSlope = slopeDistance;
        }
        return minSlope;
    }

    protected boolean m_75956_(BlockGetter level, Fluid fluid, BlockPos pos, BlockState block, BlockPos spreadPos, BlockState spreadBlock) {
        return this.m_76061_(Direction.UP, level, pos, block, spreadPos, spreadBlock) && (spreadBlock.m_60819_().m_76152_().m_6212_((Fluid)this) || this.m_75972_(level, spreadPos, spreadBlock, fluid));
    }

    protected Map<Direction, FluidState> m_76079_(Level level, BlockPos pos, BlockState block) {
        int minDistance = 1000;
        EnumMap spread = Maps.newEnumMap(Direction.class);
        Short2ObjectOpenHashMap stateCache = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap waterHoleCache = new Short2BooleanOpenHashMap();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int distance;
            BlockPos side = pos.m_121945_(direction);
            short key = InvertedFluid.m_76058_((BlockPos)pos, (BlockPos)side);
            Pair pair = (Pair)stateCache.computeIfAbsent(key, k -> {
                BlockState sideBlock = level.m_8055_(side);
                return Pair.of((Object)sideBlock, (Object)sideBlock.m_60819_());
            });
            BlockState sideBlock = (BlockState)pair.getFirst();
            FluidState sideFluid = (FluidState)pair.getSecond();
            FluidState newFluid = this.m_76035_(level, side, sideBlock);
            if (!this.m_75963_((BlockGetter)level, newFluid.m_76152_(), pos, block, direction, side, sideBlock, sideFluid)) continue;
            BlockPos above = side.m_7494_();
            boolean isWaterHole = waterHoleCache.computeIfAbsent(key, p_255612_ -> {
                BlockState aboveBlock = level.m_8055_(above);
                return this.m_75956_((BlockGetter)level, this.m_5615_(), side, sideBlock, above, aboveBlock);
            });
            int n = distance = isWaterHole ? 0 : this.m_76026_((LevelReader)level, side, 1, direction.m_122424_(), sideBlock, pos, (Short2ObjectMap<Pair<BlockState, FluidState>>)stateCache, (Short2BooleanMap)waterHoleCache);
            if (distance < minDistance) {
                spread.clear();
            }
            if (distance > minDistance) continue;
            spread.put(direction, newFluid);
            minDistance = distance;
        }
        return spread;
    }

    public static class Source
    extends InvertedFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int m_7430_(FluidState state) {
            return 8;
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends InvertedFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

