/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.block;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.RegistryPredicateRegistry;

public interface BlockPredicate
extends IJsonPredicate<BlockState> {
    public static final BlockPredicate ANY = BlockPredicate.simple(state -> true);
    public static final RegistryPredicateRegistry<Block, BlockState> LOADER = new RegistryPredicateRegistry<Block, BlockState>("Block Predicate", ANY, Loadables.BLOCK, BlockBehaviour.BlockStateBase::m_60734_, "blocks", Loadables.BLOCK_TAG, (tag, state) -> state.m_204336_(tag));
    public static final BlockPredicate REQUIRES_TOOL = BlockPredicate.simple(BlockBehaviour.BlockStateBase::m_60834_);
    public static final BlockPredicate BLOCKS_MOTION = BlockPredicate.simple(BlockBehaviour.BlockStateBase::m_280555_);
    public static final BlockPredicate CAN_BE_REPLACED = BlockPredicate.simple(BlockBehaviour.BlockStateBase::m_247087_);

    @Override
    default public IJsonPredicate<BlockState> inverted() {
        return LOADER.invert(this);
    }

    public static BlockPredicate simple(final Predicate<BlockState> predicate) {
        return SingletonLoader.singleton(loader -> new BlockPredicate(){
            final /* synthetic */ RecordLoadable val$loader;
            {
                this.val$loader = recordLoadable;
            }

            @Override
            public boolean matches(BlockState state) {
                return predicate.test(state);
            }

            @Override
            public RecordLoadable<? extends BlockPredicate> getLoader() {
                return this.val$loader;
            }
        });
    }

    public static IJsonPredicate<BlockState> set(Block ... blocks) {
        return LOADER.setOf((Block[])blocks);
    }

    public static IJsonPredicate<BlockState> tag(TagKey<Block> tag) {
        return LOADER.tag(tag);
    }

    @SafeVarargs
    public static IJsonPredicate<BlockState> and(IJsonPredicate<BlockState> ... predicates) {
        return LOADER.and(List.of(predicates));
    }

    @SafeVarargs
    public static IJsonPredicate<BlockState> or(IJsonPredicate<BlockState> ... predicates) {
        return LOADER.or(List.of(predicates));
    }
}

