/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.texture;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.joml.Vector3f;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.mantle.fluid.texture.FluidTexture;
import slimeknights.mantle.fluid.texture.FluidTextureManager;

public class ClientTextureFluidType
implements IClientFluidTypeExtensions {
    protected final FluidType type;
    private Vector3f fogColor;

    public int getTintColor() {
        return FluidTextureManager.getColor(this.type);
    }

    public ResourceLocation getStillTexture() {
        return FluidTextureManager.getStillTexture(this.type);
    }

    public ResourceLocation getFlowingTexture() {
        return FluidTextureManager.getFlowingTexture(this.type);
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return FluidTextureManager.getOverlayTexture(this.type);
    }

    @Nullable
    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
        return FluidTextureManager.getCameraTexture(this.type);
    }

    public void renderOverlay(Minecraft mc, PoseStack poseStack) {
        FluidTexture data = FluidTextureManager.getData(this.type);
        ResourceLocation camera = data.camera();
        if (camera != null) {
            FluidRenderer.renderCamera(mc, poseStack, camera, data.cameraOpacity(), data.color());
        }
    }

    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
        int fluidColor = FluidTextureManager.getData(this.type).fogColor();
        if (fluidColor != -1) {
            if (this.fogColor == null) {
                this.fogColor = new Vector3f((float)FastColor.ARGB32.m_13665_((int)fluidColor) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)fluidColor) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)fluidColor) / 255.0f);
            }
            fluidFogColor.x *= this.fogColor.x;
            fluidFogColor.y *= this.fogColor.y;
            fluidFogColor.z *= this.fogColor.z;
        }
        return fluidFogColor;
    }

    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
        FluidTexture data = FluidTextureManager.getData(this.type);
        FogShape overrideShape = data.fogShape();
        if (overrideShape != null) {
            float end;
            float start;
            if (overrideShape != shape) {
                RenderSystem.setShaderFogShape((FogShape)overrideShape);
            }
            if ((start = data.fogStart()) < nearDistance) {
                RenderSystem.setShaderFogStart((float)start);
            }
            if ((end = data.fogEnd()) < farDistance) {
                RenderSystem.setShaderFogEnd((float)end);
            }
        }
    }

    public ClientTextureFluidType(FluidType type) {
        this.type = type;
    }
}

