/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.texture;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.client.model.TextureColorHelper;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.util.JsonHelper;

public final class FluidTexture {
    private final ResourceLocation still;
    private final ResourceLocation flowing;
    @Nullable
    private final ResourceLocation overlay;
    @Nullable
    private final ResourceLocation camera;
    private final float cameraOpacity;
    private final int color;
    private int fogColor;
    private final boolean calculateFogColor;

    @Deprecated(forRemoval=true)
    public FluidTexture(ResourceLocation still, ResourceLocation flowing, @Nullable ResourceLocation overlay, @Nullable ResourceLocation camera, int color) {
        this(still, flowing, overlay, camera, 0.1f, color, -1, false);
    }

    public int fogColor() {
        if (this.calculateFogColor && this.fogColor == -1) {
            this.fogColor = TextureColorHelper.getAverageColor(this.still);
        }
        return this.fogColor;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("still", this.still.toString());
        json.addProperty("flowing", this.flowing.toString());
        if (this.overlay != null) {
            json.addProperty("overlay", this.overlay.toString());
        }
        if (this.camera != null) {
            if (this.cameraOpacity <= 0.0f || this.cameraOpacity > 1.0f) {
                throw new IllegalStateException("Camera opacity must be between 0 (exclusive) and 1 (inclusive)");
            }
            json.addProperty("camera", this.camera.toString());
            json.addProperty("camera_opacity", (Number)Float.valueOf(this.cameraOpacity));
        }
        json.add("color", ColorLoadable.ALPHA.serialize(this.color));
        if (this.fogColor != -1) {
            json.add("fog_color", ColorLoadable.NO_ALPHA.serialize(this.fogColor));
        } else if (this.calculateFogColor) {
            json.addProperty("calculate_fog_color", Boolean.valueOf(true));
        }
        return json;
    }

    public static FluidTexture deserialize(JsonObject json) {
        ResourceLocation still = JsonHelper.getResourceLocation(json, "still");
        ResourceLocation flowing = JsonHelper.getResourceLocation(json, "flowing");
        ResourceLocation overlay = JsonHelper.getResourceLocation(json, "overlay", null);
        ResourceLocation camera = null;
        float cameraOpacity = 0.0f;
        if (json.has("camera")) {
            camera = JsonHelper.wrap(JsonHelper.getResourceLocation(json, "camera"), "textures/", ".png");
            cameraOpacity = GsonHelper.m_13915_((JsonObject)json, (String)"camera_opacity");
            if (cameraOpacity <= 0.0f || cameraOpacity > 1.0f) {
                throw new JsonSyntaxException("Camera opacity must be between 0 (exclusive) and 1 (inclusive)");
            }
        }
        int color = ColorLoadable.ALPHA.getOrWhite(json, "color");
        int fogColor = color | 0xFF000000;
        boolean calculateFogColor = false;
        if (json.has("fog_color")) {
            fogColor = (Integer)ColorLoadable.NO_ALPHA.getIfPresent(json, "fog_color");
        } else if (color == -1) {
            calculateFogColor = GsonHelper.m_13855_((JsonObject)json, (String)"calculate_fog_color", (boolean)false);
        }
        return new FluidTexture(still, flowing, overlay, camera, cameraOpacity, color, fogColor, calculateFogColor);
    }

    public ResourceLocation still() {
        return this.still;
    }

    public ResourceLocation flowing() {
        return this.flowing;
    }

    @Nullable
    public ResourceLocation overlay() {
        return this.overlay;
    }

    @Nullable
    public ResourceLocation camera() {
        return this.camera;
    }

    public float cameraOpacity() {
        return this.cameraOpacity;
    }

    public int color() {
        return this.color;
    }

    public boolean calculateFogColor() {
        return this.calculateFogColor;
    }

    public FluidTexture fogColor(int fogColor) {
        this.fogColor = fogColor;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FluidTexture)) {
            return false;
        }
        FluidTexture other = (FluidTexture)o;
        if (Float.compare(this.cameraOpacity(), other.cameraOpacity()) != 0) {
            return false;
        }
        if (this.color() != other.color()) {
            return false;
        }
        if (this.fogColor() != other.fogColor()) {
            return false;
        }
        if (this.calculateFogColor() != other.calculateFogColor()) {
            return false;
        }
        ResourceLocation this$still = this.still();
        ResourceLocation other$still = other.still();
        if (this$still == null ? other$still != null : !this$still.equals(other$still)) {
            return false;
        }
        ResourceLocation this$flowing = this.flowing();
        ResourceLocation other$flowing = other.flowing();
        if (this$flowing == null ? other$flowing != null : !this$flowing.equals(other$flowing)) {
            return false;
        }
        ResourceLocation this$overlay = this.overlay();
        ResourceLocation other$overlay = other.overlay();
        if (this$overlay == null ? other$overlay != null : !this$overlay.equals(other$overlay)) {
            return false;
        }
        ResourceLocation this$camera = this.camera();
        ResourceLocation other$camera = other.camera();
        return !(this$camera == null ? other$camera != null : !this$camera.equals(other$camera));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.cameraOpacity());
        result = result * 59 + this.color();
        result = result * 59 + this.fogColor();
        result = result * 59 + (this.calculateFogColor() ? 79 : 97);
        ResourceLocation $still = this.still();
        result = result * 59 + ($still == null ? 43 : $still.hashCode());
        ResourceLocation $flowing = this.flowing();
        result = result * 59 + ($flowing == null ? 43 : $flowing.hashCode());
        ResourceLocation $overlay = this.overlay();
        result = result * 59 + ($overlay == null ? 43 : $overlay.hashCode());
        ResourceLocation $camera = this.camera();
        result = result * 59 + ($camera == null ? 43 : $camera.hashCode());
        return result;
    }

    public String toString() {
        return "FluidTexture(still=" + this.still() + ", flowing=" + this.flowing() + ", overlay=" + this.overlay() + ", camera=" + this.camera() + ", cameraOpacity=" + this.cameraOpacity() + ", color=" + this.color() + ", fogColor=" + this.fogColor() + ", calculateFogColor=" + this.calculateFogColor() + ")";
    }

    public FluidTexture(ResourceLocation still, ResourceLocation flowing, @Nullable ResourceLocation overlay, @Nullable ResourceLocation camera, float cameraOpacity, int color, int fogColor, boolean calculateFogColor) {
        this.still = still;
        this.flowing = flowing;
        this.overlay = overlay;
        this.camera = camera;
        this.cameraOpacity = cameraOpacity;
        this.color = color;
        this.fogColor = fogColor;
        this.calculateFogColor = calculateFogColor;
    }

    public static class Builder {
        private final FluidType fluid;
        private ResourceLocation root;
        private ResourceLocation still;
        private ResourceLocation flowing;
        @Nullable
        private ResourceLocation overlay = null;
        @Nullable
        private ResourceLocation camera = null;
        private float cameraOpacity = 0.1f;
        private int color = -1;
        private int fogColor = -1;
        private boolean calculateFogColor = false;

        public Builder wrapId(String prefix, String suffix, boolean overlay, boolean camera) {
            return this.textures(JsonHelper.wrap(Objects.requireNonNull(((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)this.fluid)), prefix, suffix), overlay, camera);
        }

        public Builder still() {
            if (this.root == null) {
                throw new IllegalStateException("Automatic still texture requires root to be set");
            }
            return this.still(this.root.m_266382_("still"));
        }

        public Builder flowing() {
            if (this.root == null) {
                throw new IllegalStateException("Automatic flowing texture requires root to be set");
            }
            return this.flowing(this.root.m_266382_("flowing"));
        }

        public Builder overlay() {
            if (this.root == null) {
                throw new IllegalStateException("Automatic overlay texture requires root to be set");
            }
            return this.overlay(this.root.m_266382_("overlay"));
        }

        public Builder camera() {
            if (this.root == null) {
                throw new IllegalStateException("Automatic camera texture requires root to be set");
            }
            return this.camera(this.root.m_266382_("camera"));
        }

        @Deprecated
        public Builder textures(ResourceLocation path, boolean overlay, boolean camera) {
            this.root(path).still().flowing();
            if (overlay) {
                this.overlay();
            }
            if (camera) {
                this.camera();
            }
            return this;
        }

        public FluidTexture build() {
            if (this.still == null || this.flowing == null) {
                throw new IllegalStateException("Must set both still and flowing");
            }
            return new FluidTexture(this.still, this.flowing, this.overlay, this.camera, this.cameraOpacity, this.color, this.fogColor, this.fogColor == -1 && this.calculateFogColor);
        }

        public ResourceLocation getStill() {
            return Objects.requireNonNull(this.still, "Still must be set");
        }

        public ResourceLocation getFlowing() {
            return Objects.requireNonNull(this.flowing, "Flowing must be set");
        }

        @Nullable
        public ResourceLocation getCamera() {
            return this.camera;
        }

        @Nullable
        public ResourceLocation getOverlay() {
            return this.overlay;
        }

        public Builder root(ResourceLocation root) {
            this.root = root;
            return this;
        }

        public Builder still(ResourceLocation still) {
            this.still = still;
            return this;
        }

        public Builder flowing(ResourceLocation flowing) {
            this.flowing = flowing;
            return this;
        }

        public Builder overlay(@Nullable ResourceLocation overlay) {
            this.overlay = overlay;
            return this;
        }

        public Builder camera(@Nullable ResourceLocation camera) {
            this.camera = camera;
            return this;
        }

        public Builder cameraOpacity(float cameraOpacity) {
            this.cameraOpacity = cameraOpacity;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder fogColor(int fogColor) {
            this.fogColor = fogColor;
            return this;
        }

        public Builder calculateFogColor(boolean calculateFogColor) {
            this.calculateFogColor = calculateFogColor;
            return this;
        }

        public Builder(FluidType fluid) {
            this.fluid = fluid;
        }
    }
}

