/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.cooking;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mojang.datafixers.util.Function7;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.cooking.BlastingResultRecipe;
import slimeknights.mantle.recipe.cooking.CampfireResultRecipe;
import slimeknights.mantle.recipe.cooking.SmeltingResultRecipe;
import slimeknights.mantle.recipe.cooking.SmokingResultRecipe;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;

@CanIgnoreReturnValue
public class CookingRecipeBuilder<T extends CookingRecipeBuilder<T>>
extends AbstractRecipeBuilder<T> {
    protected final ItemOutput result;
    protected float experience = 1.0f;
    protected int cookingTime = 200;
    protected Ingredient ingredient = Ingredient.f_43901_;
    protected CookingBookCategory category = CookingBookCategory.MISC;
    protected CookingType type = CookingType.SMELTING;

    public static CookingRecipeBuilder<?> builder(ItemLike output, int amount) {
        return CookingRecipeBuilder.builder(ItemOutput.fromItem(output, amount));
    }

    public static CookingRecipeBuilder<?> builder(ItemLike output) {
        return CookingRecipeBuilder.builder(output, 1);
    }

    public static CookingRecipeBuilder<?> builder(TagKey<Item> result, int amount) {
        return CookingRecipeBuilder.builder(ItemOutput.fromTag(result, amount));
    }

    public static CookingRecipeBuilder<?> builder(TagKey<Item> result) {
        return CookingRecipeBuilder.builder(result, 1);
    }

    public T type(CookingType type) {
        this.type = type;
        return (T)this;
    }

    public T requires(Ingredient ingredient) {
        this.ingredient = ingredient;
        return (T)this;
    }

    public T requires(ItemLike item) {
        return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public T requires(TagKey<Item> tag) {
        return this.requires(Ingredient.m_204132_(tag));
    }

    public T experience(float experience) {
        this.experience = experience;
        return (T)this;
    }

    public T cookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
        return (T)this;
    }

    private <R extends Recipe<?>> T save(Consumer<FinishedRecipe> consumer, ResourceLocation id, RecordLoadable<R> loadable, Function7<ResourceLocation, String, CookingBookCategory, Ingredient, ItemOutput, Float, Integer, R> constructor, int cookingTime) {
        if (this.ingredient == Ingredient.f_43901_) {
            throw new IllegalStateException("Ingredient must be set");
        }
        ResourceLocation advancementID = this.buildOptionalAdvancement(id, "cooking");
        consumer.accept(new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)constructor.apply((Object)id, (Object)this.group, (Object)this.category, (Object)this.ingredient, (Object)this.result, (Object)Float.valueOf(this.experience), (Object)cookingTime), loadable, advancementID));
        return (T)this;
    }

    public T saveSmelting(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        return this.save(consumer, id, SmeltingResultRecipe.LOADABLE, SmeltingResultRecipe::new, this.cookingTime);
    }

    public T saveBlasting(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        return this.save(consumer, id, BlastingResultRecipe.LOADABLE, BlastingResultRecipe::new, this.cookingTime / 2);
    }

    public T saveSmoking(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        return this.save(consumer, id, SmokingResultRecipe.LOADABLE, SmokingResultRecipe::new, this.cookingTime / 2);
    }

    public T saveCampfire(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        return this.save(consumer, id, CampfireResultRecipe.LOADABLE, CampfireResultRecipe::new, this.cookingTime * 3);
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Loadables.ITEM.getKey(this.result.get().m_41720_()));
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        switch (this.type) {
            case SMELTING: {
                this.saveSmelting(consumer, id);
                break;
            }
            case BLASTING: {
                this.saveBlasting(consumer, id);
                break;
            }
            case SMOKING: {
                this.saveSmoking(consumer, id);
                break;
            }
            case CAMPFIRE: {
                this.saveCampfire(consumer, id);
            }
        }
    }

    private CookingRecipeBuilder(ItemOutput result) {
        this.result = result;
    }

    protected static <T extends CookingRecipeBuilder<T>> CookingRecipeBuilder<T> builder(ItemOutput result) {
        return new CookingRecipeBuilder<T>(result);
    }

    public static enum CookingType {
        SMELTING,
        BLASTING,
        SMOKING,
        CAMPFIRE;

    }
}

