/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;

public class ItemNameIngredient
extends AbstractIngredient {
    private final List<ResourceLocation> names;

    protected ItemNameIngredient(List<ResourceLocation> names) {
        super(names.stream().map(NamedValue::new));
        this.names = names;
    }

    public static ItemNameIngredient from(List<ResourceLocation> names) {
        return new ItemNameIngredient(names);
    }

    public static ItemNameIngredient from(ResourceLocation ... names) {
        return ItemNameIngredient.from(Arrays.asList(names));
    }

    public boolean test(@Nullable ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    private static JsonObject forName(ResourceLocation name) {
        JsonObject json = new JsonObject();
        json.addProperty("item", name.toString());
        return json;
    }

    public JsonElement m_43942_() {
        if (this.names.size() == 1) {
            return ItemNameIngredient.forName(this.names.get(0));
        }
        JsonArray array = new JsonArray();
        for (ResourceLocation name : this.names) {
            array.add((JsonElement)ItemNameIngredient.forName(name));
        }
        return array;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return VanillaIngredientSerializer.INSTANCE;
    }

    public static class NamedValue
    implements Ingredient.Value {
        private final ResourceLocation name;

        public Collection<ItemStack> m_6223_() {
            throw new UnsupportedOperationException();
        }

        public JsonObject m_6544_() {
            JsonObject json = new JsonObject();
            json.addProperty("item", this.name.toString());
            return json;
        }

        public NamedValue(ResourceLocation name) {
            this.name = name;
        }
    }
}

