/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.loot.LootTableInjection;

public abstract class AbstractLootTableInjectionProvider
extends GenericDataProvider {
    private final List<Builder> builders = new ArrayList<Builder>();
    private final String domain;

    public AbstractLootTableInjectionProvider(PackOutput output, String domain) {
        super(output, PackOutput.Target.DATA_PACK, "mantle/loot_injectors");
        this.domain = domain;
    }

    protected abstract void addTables();

    public final CompletableFuture<?> m_213708_(CachedOutput output) {
        this.addTables();
        return this.allOf(this.builders.stream().map(builder -> {
            JsonObject json = LootTableInjection.LOADABLE.serialize(builder.build()).getAsJsonObject();
            if (builder.conditions.length > 0) {
                json.add("conditions", (JsonElement)CraftingHelper.serialize((ICondition[])builder.conditions));
            }
            return this.saveJson(output, new ResourceLocation(this.domain, builder.path), json);
        }));
    }

    protected LootTableInjection.Builder inject(String path, ResourceLocation name, ICondition ... conditions) {
        LootTableInjection.Builder builder = new LootTableInjection.Builder();
        this.builders.add(new Builder(path, name, builder, conditions));
        return builder;
    }

    protected LootTableInjection.Builder inject(String path, String name, ICondition ... conditions) {
        return this.inject(path, new ResourceLocation(name), conditions);
    }

    protected LootTableInjection.Builder injectChest(String name, ICondition ... conditions) {
        return this.inject(name, new ResourceLocation("chests/" + name), conditions);
    }

    protected LootTableInjection.Builder injectGameplay(String name, ICondition ... conditions) {
        return this.inject(name, new ResourceLocation("gameplay/" + name), conditions);
    }

    private record Builder(String path, ResourceLocation name, LootTableInjection.Builder builder, ICondition[] conditions) {
        public LootTableInjection build() {
            return this.builder.build(this.name);
        }
    }
}

