/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.tooltip;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.mantle.fluid.tooltip.FluidUnit;
import slimeknights.mantle.fluid.tooltip.FluidUnitList;

public abstract class AbstractFluidTooltipProvider
extends GenericDataProvider {
    private final Map<ResourceLocation, ResourceLocation> redirects = new HashMap<ResourceLocation, ResourceLocation>();
    private final Map<ResourceLocation, FluidUnitListBuilder> builders = new HashMap<ResourceLocation, FluidUnitListBuilder>();
    private final String modId;

    public AbstractFluidTooltipProvider(PackOutput output, String modId) {
        super(output, PackOutput.Target.RESOURCE_PACK, "mantle/fluid_tooltips", FluidTooltipHandler.GSON);
        this.modId = modId;
    }

    protected abstract void addFluids();

    public final CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addFluids();
        return this.allOf(Stream.concat(this.builders.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((FluidUnitListBuilder)entry.getValue()).build())), this.redirects.entrySet().stream().map(entry -> {
            JsonObject json = new JsonObject();
            json.addProperty("redirect", ((ResourceLocation)entry.getValue()).toString());
            return this.saveJson(cache, (ResourceLocation)entry.getKey(), json);
        })));
    }

    protected ResourceLocation id(String name) {
        return new ResourceLocation(this.modId, name);
    }

    protected FluidUnitListBuilder add(ResourceLocation id, @Nullable TagKey<Fluid> tag) {
        if (this.redirects.containsKey(id)) {
            throw new IllegalArgumentException(id + " is already registered as a redirect");
        }
        FluidUnitListBuilder newBuilder = new FluidUnitListBuilder(tag);
        FluidUnitListBuilder original = this.builders.put(id, newBuilder);
        if (original != null) {
            throw new IllegalArgumentException(id + " is already registered");
        }
        return newBuilder;
    }

    protected FluidUnitListBuilder add(String id, TagKey<Fluid> tag) {
        return this.add(this.id(id), tag);
    }

    protected FluidUnitListBuilder add(TagKey<Fluid> tag) {
        return this.add(this.id(tag.f_203868_().m_135815_()), tag);
    }

    protected FluidUnitListBuilder add(ResourceLocation id) {
        return this.add(id, null);
    }

    protected FluidUnitListBuilder add(String id) {
        return this.add(this.id(id), null);
    }

    protected void addRedirect(ResourceLocation id, ResourceLocation target) {
        if (this.builders.containsKey(id)) {
            throw new IllegalArgumentException(id + " is already registered as a unit list");
        }
        ResourceLocation original = this.redirects.put(id, target);
        if (original != null) {
            throw new IllegalArgumentException(id + " is already redirecting to " + original);
        }
    }

    protected class FluidUnitListBuilder {
        @Nullable
        private final TagKey<Fluid> tag;
        private final ImmutableList.Builder<FluidUnit> units = ImmutableList.builder();

        public FluidUnitListBuilder addUnitRaw(String key, int amount) {
            this.units.add((Object)new FluidUnit(key, amount));
            return this;
        }

        public FluidUnitListBuilder addUnit(String key, int amount) {
            return this.addUnitRaw(Util.m_137492_((String)"gui", (ResourceLocation)AbstractFluidTooltipProvider.this.id("fluid." + key)), amount);
        }

        public FluidUnitListBuilder addUnit(String key, String domain, int amount) {
            return this.addUnitRaw(Util.m_137492_((String)"gui", (ResourceLocation)new ResourceLocation(domain, "fluid." + key)), amount);
        }

        private FluidUnitList build() {
            return new FluidUnitList(this.tag, (List<FluidUnit>)this.units.build());
        }

        private FluidUnitListBuilder(TagKey<Fluid> tag) {
            this.tag = tag;
        }
    }
}

