/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import slimeknights.mantle.config.Config;

public class ExtraHeartRenderHandler {
    private static final ResourceLocation ICON_HEARTS = new ResourceLocation("mantle", "textures/gui/extra_hearts.png");
    private static final ResourceLocation ICON_VANILLA = Gui.f_279580_;
    private static final int ROW_HEIGHT = 10;
    private final int[] offsets = new int[20];
    private final Minecraft mc = Minecraft.m_91087_();
    private int lastHealth = 0;
    private int displayHealth = 0;
    private long healthBlinkTime = 0L;
    private long lastHealthTime = 0L;
    private final Random rand = new Random();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void renderHealthbar(RenderGuiOverlayEvent.Pre event) {
        ForgeGui gui;
        block27: {
            block26: {
                if (event.isCanceled() || !((Boolean)Config.EXTRA_HEART_RENDERER.get()).booleanValue() || event.getOverlay() != VanillaGuiOverlay.PLAYER_HEALTH.type()) {
                    return;
                }
                Gui gui2 = this.mc.f_91065_;
                if (!(gui2 instanceof ForgeGui)) break block26;
                gui = (ForgeGui)gui2;
                if (!this.mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) break block27;
            }
            return;
        }
        Entity renderViewEnity = this.mc.m_91288_();
        if (!(renderViewEnity instanceof Player)) {
            return;
        }
        Player player = (Player)renderViewEnity;
        gui.setupOverlayRenderState(true, false);
        this.mc.m_91307_().m_6180_("health");
        int tickCount = this.mc.f_91065_.m_93079_();
        int health = Mth.m_14167_((float)player.m_21223_());
        boolean highlight = this.healthBlinkTime > (long)tickCount && (this.healthBlinkTime - (long)tickCount) / 3L % 2L == 1L;
        long systemTime = Util.m_137550_();
        if (player.f_19802_ > 0) {
            if (health < this.lastHealth) {
                this.lastHealthTime = systemTime;
                this.healthBlinkTime = tickCount + 20;
            } else if (health > this.lastHealth) {
                this.lastHealthTime = systemTime;
                this.healthBlinkTime = tickCount + 10;
            }
        }
        if (systemTime - this.lastHealthTime > 1000L) {
            this.displayHealth = health;
            this.lastHealthTime = systemTime;
        }
        this.lastHealth = health;
        int displayHealth = this.displayHealth;
        this.rand.setSeed((long)tickCount * 312871L);
        Window window = this.mc.m_91268_();
        int left = window.m_85445_() / 2 - 91;
        int top = window.m_85446_() - gui.leftHeight;
        int showHealth = Math.min(Math.max(Mth.m_14165_((double)player.m_21133_(Attributes.f_22276_)), Math.max(displayHealth, health)), 20);
        int absorb = Mth.m_14167_((float)player.m_6103_());
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = tickCount % 25;
        }
        int container = 0;
        int heartOffset = 0;
        int absorpOffset = 216;
        if (player.m_21023_(MobEffects.f_19614_)) {
            heartOffset = 36;
        } else if (player.m_21023_(MobEffects.f_19615_)) {
            heartOffset = 72;
            absorpOffset = 72;
        } else if (player.m_146890_()) {
            heartOffset = 108;
        }
        assert (this.mc.f_91073_ != null);
        if (this.mc.f_91073_.m_6106_().m_5466_()) {
            heartOffset += 9;
            container += 9;
            heartOffset += 9;
        }
        boolean wiggle = health + absorb <= 4;
        int showHearts = (showHealth + 1) / 2;
        boolean compactAbsorption = showHearts < 10 && absorb <= 2 * (10 - showHearts);
        GuiGraphics graphics = event.getGuiGraphics();
        this.renderContainerRow(graphics, left, top, container, 0, showHealth / 2, showHealth < 20 && showHealth % 2 == 1, highlight, wiggle, regen);
        if (absorb > 0) {
            boolean half = absorb < 20 && absorb % 2 == 1;
            int absorbHearts = absorb / 2;
            if (compactAbsorption) {
                this.renderContainerRow(graphics, left + 8 * showHearts, top, container, 10, absorbHearts, half, highlight, wiggle, -1);
            } else {
                this.renderContainerRow(graphics, left, top - 10, container, 10, Math.min(absorbHearts, 10), half, highlight, wiggle, -1);
            }
        }
        if (highlight && displayHealth > health) {
            this.renderHeartsWithDamage(graphics, left, top, heartOffset, health, displayHealth);
        } else {
            this.renderHearts(graphics, left, top, heartOffset, health, 0);
        }
        if (compactAbsorption) {
            int absorbHearts = absorb / 2;
            this.renderHeartRow(graphics, left + showHearts * 8, top, absorpOffset, 10, 0, 0, absorbHearts, absorb % 2 == 1);
        } else {
            this.renderHearts(graphics, left, top - 10, absorpOffset, absorb, 10);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ICON_VANILLA);
        gui.leftHeight += 10;
        if (absorb > 0) {
            gui.leftHeight += 10;
        }
        event.setCanceled(true);
        RenderSystem.disableBlend();
        this.mc.m_91307_().m_7238_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Post(event.getWindow(), graphics, event.getPartialTick(), VanillaGuiOverlay.PLAYER_HEALTH.type()));
    }

    private void renderHearts(GuiGraphics graphics, int x, int y, int heartOffset, int count, int indexOffset) {
        int heartsTopColor = count % 20 / 2;
        int heartIndex = count / 20;
        if (count >= 20) {
            this.renderHeartRow(graphics, x, y, heartOffset, indexOffset, heartIndex - 1, heartsTopColor, 10, false);
        }
        this.renderHeartRow(graphics, x, y, heartOffset, indexOffset, heartIndex, 0, heartsTopColor, count % 2 == 1);
    }

    private void renderHeartsWithDamage(GuiGraphics graphics, int x, int y, int heartOffset, int current, int last) {
        boolean damageWrapped;
        int currentTopRow = current % 20;
        int currentRight = currentTopRow / 2;
        int lastTopRow = last % 20;
        int lastRight = lastTopRow / 2;
        int damageTaken = last - current;
        boolean bigDamage = damageTaken >= 20;
        boolean bl = damageWrapped = bigDamage || lastRight < currentRight;
        if (damageWrapped) {
            this.renderHeartRow(graphics, x, y, heartOffset + 18, 0, last / 20 - 1, bigDamage ? lastRight : currentRight, 10, false);
        } else {
            if (current >= 20) {
                this.renderHeartRow(graphics, x, y, heartOffset, 0, current / 20 - 1, lastRight, 10, false);
            }
            this.renderHeartRow(graphics, x, y, heartOffset + 18, 0, last / 20, currentRight, lastRight, lastTopRow % 2 == 1);
        }
        if (!bigDamage) {
            this.renderHeartRow(graphics, x, y, heartOffset, 0, current / 20, damageWrapped ? lastRight : 0, currentRight, currentTopRow % 2 == 1);
        }
        if (damageWrapped) {
            this.renderHeartRow(graphics, x, y, heartOffset + 18, 0, last / 20, 0, lastRight, lastTopRow % 2 == 1);
        }
    }

    private void renderHeartRow(GuiGraphics graphics, int x, int y, int typeOffset, int indexOffset, int heartIndex, int start, int end, boolean half) {
        heartIndex %= 12;
        for (int i = start; i < end; ++i) {
            graphics.m_280218_(ICON_HEARTS, x + 8 * i, y + this.offsets[i + indexOffset], 18 * heartIndex, typeOffset, 9, 9);
        }
        if (half) {
            graphics.m_280218_(ICON_HEARTS, x + 8 * end, y + this.offsets[end + indexOffset], 9 + 18 * heartIndex, typeOffset, 9, 9);
        }
    }

    private void renderContainerRow(GuiGraphics graphics, int x, int y, int typeOffset, int indexOffset, int end, boolean half, boolean highlight, boolean wiggle, int regen) {
        for (int i = 0; i < end; ++i) {
            int offset = 0;
            if (wiggle) {
                offset = this.rand.nextInt(2);
            }
            if (i == regen) {
                offset -= 2;
            }
            this.offsets[i + indexOffset] = offset;
            int localX = x + i * 8;
            int localY = y + offset;
            if (highlight) {
                graphics.m_280218_(ICON_HEARTS, localX, localY, 247, typeOffset + 18, 9, 9);
                continue;
            }
            graphics.m_280218_(ICON_HEARTS, localX, localY, 247, typeOffset, 9, 9);
        }
        if (half) {
            int offset = 0;
            if (wiggle) {
                offset = this.rand.nextInt(2);
            }
            if (end == regen) {
                offset -= 2;
            }
            this.offsets[end + indexOffset] = offset;
            int localX = x + end * 8;
            int localY = y + offset;
            if (highlight) {
                graphics.m_280218_(ICON_HEARTS, localX, localY, 247, typeOffset + 18 + 36, 9, 9);
            } else {
                graphics.m_280218_(ICON_HEARTS, localX, localY, 247, typeOffset + 36, 9, 9);
            }
        }
    }
}

