/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.fluid.transfer.EmptyFluidContainerTransfer;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.TagPreference;

public class EmptyPotionTransfer
extends EmptyFluidContainerTransfer {
    public static final ResourceLocation ID = Mantle.getResource("empty_potion");
    public static final RecordLoadable<EmptyPotionTransfer> LOADER = RecordLoadable.create(IngredientLoadable.DISALLOW_EMPTY.requiredField("input", t -> t.input), ItemOutput.Loadable.OPTIONAL_ITEM.emptyField("result", t -> t.result), IntLoadable.FROM_ONE.requiredField("amount", t -> t.fluid.getAmount()), EmptyPotionTransfer::new);

    public EmptyPotionTransfer(Ingredient input, ItemOutput filled, int amount) {
        super(input, filled, FluidOutput.fromFluid((Fluid)Fluids.f_76193_, amount));
    }

    @Override
    public boolean matches(ItemStack stack, FluidStack fluid) {
        return super.matches(stack, fluid) && (TagPreference.getPreference(MantleTags.Fluids.POTION).isPresent() || PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_);
    }

    @Override
    protected FluidStack getFluid(ItemStack stack) {
        if (PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) {
            return this.fluid.copy();
        }
        return TagPreference.getPreference(MantleTags.Fluids.POTION).map(value -> new FluidStack(value, this.fluid.getAmount(), stack.m_41783_())).orElse(FluidStack.EMPTY);
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("type", ID.toString());
        LOADER.serialize(this, json);
        return json;
    }
}

